/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood.utilities;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.substmodel.CodonLabeling;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.math.EmpiricalBayesPoissonSmoother;

public class DnDsLogger
implements Loggable {
    private final TreeTrait[] traits;
    private final Tree tree;
    private final int numberSites;
    private final String name;
    private final String conditionalNon = "CN";
    private final String conditionalSyn = "CS";
    private final String unconditionalNon = "UN";
    private final String unconditionalSyn = "US";
    private final boolean useSmoothing;
    private final boolean useDnMinusDs;
    private final boolean counts;
    private final boolean synonymous;
    private static final int NUM_TRAITS = 4;
    private static final int CS = 0;
    private static final int US = 1;
    private static final int CN = 2;
    private static final int UN = 3;
    private double[][] cachedValues;
    public static String[] traitNames = new String[]{"c_" + CodonLabeling.SYN.getText(), "u_" + CodonLabeling.SYN.getText(), "c_" + CodonLabeling.NON_SYN.getText(), "u_" + CodonLabeling.NON_SYN.getText()};

    public DnDsLogger(String string, Tree tree, TreeTrait[] treeTraitArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.tree = tree;
        this.traits = treeTraitArray;
        this.numberSites = this.getNumberSites();
        this.name = string;
        this.useSmoothing = bl;
        this.useDnMinusDs = bl2;
        this.counts = bl3;
        this.synonymous = bl4;
        for (int i = 0; i < 4; ++i) {
            if (treeTraitArray[i].getIntent() == TreeTrait.Intent.WHOLE_TREE) continue;
            throw new IllegalArgumentException("Only whole tree traits are currently supported in DnDsLogger");
        }
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = !this.counts ? new LogColumn[this.numberSites] : new LogColumn[this.numberSites * 2];
        int n = 0;
        if (!this.counts) {
            for (int i = 0; i < this.numberSites; ++i) {
                logColumnArray[n] = new SmoothedColumn(this.name, i);
                ++n;
            }
        } else {
            int n2;
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                logColumnArray[n] = this.synonymous ? new ConditionalColumn("CS", n2, false, true) : new ConditionalColumn("CN", n2, true, true);
                ++n;
            }
            for (n2 = 0; n2 < this.numberSites; ++n2) {
                logColumnArray[n] = this.synonymous ? new ConditionalColumn("US", n2, false, false) : new ConditionalColumn("UN", n2, true, false);
                ++n;
            }
        }
        return logColumnArray;
    }

    private double doCalculation(int n) {
        double d = !this.useDnMinusDs ? this.cachedValues[2][n] / this.cachedValues[3][n] / (this.cachedValues[0][n] / this.cachedValues[1][n]) : this.cachedValues[2][n] / this.cachedValues[3][n] - this.cachedValues[0][n] / this.cachedValues[1][n];
        return d;
    }

    private int getNumberSites() {
        double[] dArray = (double[])this.traits[0].getTrait(this.tree, this.tree.getRoot());
        return dArray.length;
    }

    private void doSmoothing() {
        if (this.cachedValues == null) {
            this.cachedValues = new double[4][];
        }
        for (int i = 0; i < 4; ++i) {
            this.cachedValues[i] = this.useSmoothing ? EmpiricalBayesPoissonSmoother.smooth((double[])this.traits[i].getTrait(this.tree, this.tree.getRoot())) : (double[])this.traits[i].getTrait(this.tree, this.tree.getRoot());
        }
    }

    private class SmoothedColumn
    extends NumberColumn {
        private final int index;

        public SmoothedColumn(String string, int n) {
            super(string + "[" + (n + 1) + "]");
            this.index = n;
        }

        @Override
        public double getDoubleValue() {
            if (this.index == 0) {
                DnDsLogger.this.doSmoothing();
            }
            return DnDsLogger.this.doCalculation(this.index);
        }
    }

    private class ConditionalColumn
    extends NumberColumn {
        private final int index;
        boolean nonsynonymous;
        boolean conditional;

        public ConditionalColumn(String string, int n, boolean bl, boolean bl2) {
            super(string + "[" + (n + 1) + "]");
            this.nonsynonymous = false;
            this.conditional = true;
            this.index = n;
            if (bl) {
                this.nonsynonymous = true;
            }
            if (!bl2) {
                this.conditional = false;
            }
        }

        @Override
        public double getDoubleValue() {
            if (this.index == 0) {
                DnDsLogger.this.doSmoothing();
            }
            if (this.conditional) {
                if (this.nonsynonymous) {
                    return DnDsLogger.this.cachedValues[2][this.index];
                }
                return DnDsLogger.this.cachedValues[0][this.index];
            }
            if (this.nonsynonymous) {
                return DnDsLogger.this.cachedValues[3][this.index];
            }
            return DnDsLogger.this.cachedValues[1][this.index];
        }
    }
}

