/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.preorder.ModelExtensionProvider;
import dr.math.matrixAlgebra.Matrix;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class TreeTraitProviderTest
implements Reportable {
    private final TreeDataLikelihood treeDataLikelihood;
    private final ModelExtensionProvider.NormalExtensionProvider modelExtensionProvider;
    private final Tree tree;
    private final TreeTrait tipTrait;
    private static final int REPS = 1000;
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private static final String TRAIT_PROVIDER_TEST = "treeTraitReporter";

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
            ModelExtensionProvider.NormalExtensionProvider normalExtensionProvider = (ModelExtensionProvider.NormalExtensionProvider)xMLObject.getChild(ModelExtensionProvider.NormalExtensionProvider.class);
            return new TreeTraitProviderTest(treeDataLikelihood, normalExtensionProvider);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(TreeDataLikelihood.class), new ElementRule(ModelExtensionProvider.NormalExtensionProvider.class)};
        }

        @Override
        public String getParserDescription() {
            return "Calculates the average tree traits (and transformed tree traits)";
        }

        @Override
        public Class getReturnType() {
            return TreeTraitProviderTest.class;
        }

        @Override
        public String getParserName() {
            return TRAIT_PROVIDER_TEST;
        }
    };

    public TreeTraitProviderTest(TreeDataLikelihood treeDataLikelihood, ModelExtensionProvider.NormalExtensionProvider normalExtensionProvider) {
        this.treeDataLikelihood = treeDataLikelihood;
        this.modelExtensionProvider = normalExtensionProvider;
        this.tree = treeDataLikelihood.getTree();
        this.tipTrait = treeDataLikelihood.getTreeTrait(normalExtensionProvider.getTipTraitName());
    }

    @Override
    public String getReport() {
        int n;
        int n2;
        double[] dArray = (double[])this.tipTrait.getTrait(this.tree, null);
        double[] dArray2 = this.modelExtensionProvider.transformTreeTraits(dArray);
        for (n2 = 1; n2 < 1000; ++n2) {
            int n3;
            this.treeDataLikelihood.fireModelChanged();
            double[] dArray3 = (double[])this.tipTrait.getTrait(this.tree, null);
            double[] dArray4 = this.modelExtensionProvider.transformTreeTraits(dArray3);
            for (n3 = 0; n3 < dArray.length; ++n3) {
                int n4 = n3;
                dArray[n4] = dArray[n4] + dArray3[n3];
            }
            for (n3 = 0; n3 < dArray2.length; ++n3) {
                int n5 = n3;
                dArray2[n5] = dArray2[n5] + dArray4[n3];
            }
        }
        n2 = 0;
        while (n2 < dArray.length) {
            int n6 = n2++;
            dArray[n6] = dArray[n6] / 1000.0;
        }
        n2 = 0;
        while (n2 < dArray2.length) {
            int n7 = n2++;
            dArray2[n7] = dArray2[n7] / 1000.0;
        }
        n2 = this.modelExtensionProvider.getTraitDimension();
        int n8 = this.modelExtensionProvider.getDataDimension();
        int n9 = this.tree.getTaxonCount();
        Matrix matrix = new Matrix(n9, n2);
        Matrix matrix2 = new Matrix(n9, n8);
        for (int i = 0; i < n9; ++i) {
            for (n = 0; n < n2; ++n) {
                matrix.set(i, n, dArray[i * n2 + n]);
            }
            for (n = 0; n < n8; ++n) {
                matrix2.set(i, n, dArray2[i * n8 + n]);
            }
        }
        StringBuilder stringBuilder = new StringBuilder("Normal extension gibbs report for trait " + this.modelExtensionProvider.getTipTraitName() + ":\n");
        stringBuilder.append("\ttaxon order:");
        for (n = 0; n < n9; ++n) {
            stringBuilder.append(" " + this.tree.getTaxonId(n));
        }
        stringBuilder.append("\n");
        stringBuilder.append("\ttree trait values:\n");
        stringBuilder.append(matrix.toString(2));
        stringBuilder.append("\n");
        stringBuilder.append("\ttransformed trait values:\n");
        stringBuilder.append(matrix2.toString(2));
        stringBuilder.append("\n\n");
        return stringBuilder.toString();
    }
}

