/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.inference.model.AbstractModel;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.ArrayList;
import java.util.List;

public class ElementaryVectorDataModel
extends AbstractModel
implements ContinuousTraitPartialsProvider {
    private final Parameter tipIndicator;
    private final Parameter dimIndicator;
    private final int numTraits;
    private final int numTips;
    private final int dimTrait;
    private final PrecisionType precisionType;
    private String tipTraitName;
    private CompoundParameter traitParameter = new CompoundParameter("elementaryVector"){

        @Override
        public Parameter getParameter(int n) {
            return null;
        }

        @Override
        public double getParameterValue(int n) {
            int n2 = n / (ElementaryVectorDataModel.this.numTraits * ElementaryVectorDataModel.this.dimTrait);
            int n3 = n % (ElementaryVectorDataModel.this.numTraits * ElementaryVectorDataModel.this.dimTrait);
            int n4 = n3 / ElementaryVectorDataModel.this.dimTrait;
            int n5 = n3 % ElementaryVectorDataModel.this.dimTrait;
            if (n2 == ElementaryVectorDataModel.this.getCurrentTipIndex(n4) && n5 == ElementaryVectorDataModel.this.getCurrentDimIndex(n4)) {
                return 1.0;
            }
            return 0.0;
        }

        @Override
        public double[] getParameterValues() {
            double[] dArray = new double[ElementaryVectorDataModel.this.numTraits * ElementaryVectorDataModel.this.numTips * ElementaryVectorDataModel.this.dimTrait];
            for (int i = 0; i < ElementaryVectorDataModel.this.numTraits; ++i) {
                int n = ElementaryVectorDataModel.this.getCurrentTipIndex(i);
                int n2 = ElementaryVectorDataModel.this.getCurrentDimIndex(i);
                dArray[n * ((ElementaryVectorDataModel)ElementaryVectorDataModel.this).numTraits * ((ElementaryVectorDataModel)ElementaryVectorDataModel.this).dimTrait + i * ((ElementaryVectorDataModel)ElementaryVectorDataModel.this).dimTrait + n2] = 1.0;
            }
            return dArray;
        }

        @Override
        public int getDimension() {
            return ElementaryVectorDataModel.this.numTips * ElementaryVectorDataModel.this.numTraits * ElementaryVectorDataModel.this.dimTrait;
        }
    };
    private static List<Integer> noMissingIndices = new ArrayList<Integer>();

    public ElementaryVectorDataModel(String string, Parameter parameter, Parameter parameter2, int n, int n2, PrecisionType precisionType) {
        super(string);
        this.tipIndicator = parameter;
        this.addVariable(parameter);
        this.dimIndicator = parameter2;
        if (parameter2 != null) {
            this.addVariable(parameter2);
        }
        this.numTraits = parameter.getDimension();
        this.numTips = n;
        this.dimTrait = n2;
        this.precisionType = precisionType;
    }

    @Override
    public boolean bufferTips() {
        return true;
    }

    @Override
    public int getTraitCount() {
        return this.numTraits;
    }

    @Override
    public int getTraitDimension() {
        return this.dimTrait;
    }

    @Override
    public String getTipTraitName() {
        return this.tipTraitName;
    }

    @Override
    public void setTipTraitName(String string) {
        this.tipTraitName = string;
    }

    @Override
    public PrecisionType getPrecisionType() {
        return this.precisionType;
    }

    @Override
    public CompoundParameter getParameter() {
        return this.traitParameter;
    }

    @Override
    public boolean usesMissingIndices() {
        return false;
    }

    @Override
    public ContinuousTraitPartialsProvider[] getChildModels() {
        return new ContinuousTraitPartialsProvider[0];
    }

    public void setTipTraitDimParameters(int n, int n2, int n3) {
        this.tipIndicator.setParameterValue(n2, n);
        if (this.dimIndicator != null) {
            this.dimIndicator.setParameterValue(n2, n3);
        } else if (n3 != 0) {
            throw new RuntimeException("Not implemented");
        }
    }

    @Override
    public List<Integer> getMissingIndices() {
        return noMissingIndices;
    }

    @Override
    public boolean[] getDataMissingIndicators() {
        return null;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable == this.tipIndicator || variable == this.dimIndicator) {
            this.fireModelChanged(this);
        }
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public double[] getTipPartial(int n, boolean bl) {
        int n2 = this.precisionType.getPartialsDimension(this.dimTrait);
        double[] dArray = new double[this.numTraits * n2];
        double d = PrecisionType.getObservedPrecisionValue(false);
        int n3 = 0;
        for (int i = 0; i < this.numTraits; ++i) {
            if (n == this.getCurrentTipIndex(i)) {
                int n4 = this.getCurrentDimIndex(i);
                dArray[n3 + n4] = 1.0;
            }
            this.precisionType.fillPrecisionInPartials(dArray, n3, 0, d, this.dimTrait);
            n3 += n2;
        }
        return dArray;
    }

    private int getCurrentTipIndex(int n) {
        return (int)this.tipIndicator.getParameterValue(n);
    }

    private int getCurrentDimIndex(int n) {
        return this.dimIndicator == null ? 0 : (int)this.dimIndicator.getParameterValue(n);
    }
}

