/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.inference.model.AbstractModel;
import dr.inference.model.Bounds;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.util.Attributable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NewTreeModel
extends AbstractModel
implements MutableTree,
Citable {
    public static final String TREE_MODEL = "treeModel";
    private static final boolean TEST_NODE_BOUNDS = false;
    boolean heightBoundsSetup = false;
    private final List<TreeChangedEvent> treeChangedEvents = new ArrayList<TreeChangedEvent>();
    private Node oldRoot;
    private String id = null;
    private Attributable.AttributeHelper treeAttributes = null;
    private final List<String> keywords = new ArrayList<String>();
    private Node root = null;
    private int storedRootNumber;
    private Node[] nodes = null;
    private Node[] storedNodes = null;
    private final int nodeCount;
    private final int externalNodeCount;
    private final int internalNodeCount;
    private Units.Type units = Units.Type.SUBSTITUTIONS;
    private boolean inEdit = false;
    private boolean isTipDateSampled = false;
    private final boolean isTreeRandom;

    public NewTreeModel(String string) {
        super(string);
        this.nodeCount = 0;
        this.externalNodeCount = 0;
        this.internalNodeCount = 0;
        this.isTreeRandom = true;
    }

    public NewTreeModel(Tree tree) {
        this(TREE_MODEL, tree, false, false, false);
    }

    public NewTreeModel(String string, Tree tree) {
        this(string, tree, false, false);
    }

    public NewTreeModel(String string, Tree tree, boolean bl, boolean bl2) {
        this(string, tree, false, bl, bl2);
        this.setId(string);
    }

    public NewTreeModel(String string, Tree tree, boolean bl, boolean bl2, boolean bl3) {
        super(string);
        FlexibleTree flexibleTree = new FlexibleTree(tree, bl);
        flexibleTree.resolveTree();
        if (!bl2) {
            MutableTree.Utils.correctHeightsForTips(flexibleTree);
        }
        this.isTreeRandom = !bl3;
        Node node = new Node(flexibleTree, flexibleTree.getRoot());
        this.internalNodeCount = flexibleTree.getInternalNodeCount();
        this.externalNodeCount = flexibleTree.getExternalNodeCount();
        this.nodeCount = this.internalNodeCount + this.externalNodeCount;
        this.nodes = new Node[this.nodeCount];
        this.storedNodes = new Node[this.nodeCount];
        int n = 0;
        int n2 = this.externalNodeCount;
        this.root = node;
        do {
            if ((node = (Node)TreeUtils.postorderSuccessor(this, node)).isExternal()) {
                node.number = n;
                this.nodes[n] = node;
                this.storedNodes[n] = new Node();
                this.storedNodes[n].taxon = node.taxon;
                this.storedNodes[n].number = n;
                ++n;
                continue;
            }
            node.number = n2;
            this.nodes[n2] = node;
            this.storedNodes[n2] = new Node();
            this.storedNodes[n2].number = n2;
            ++n2;
        } while (node != this.root);
        this.setupHeightBounds();
    }

    public void setupHeightBounds() {
        if (this.heightBoundsSetup) {
            throw new IllegalArgumentException("Node height bounds set up twice");
        }
        for (int i = 0; i < this.nodeCount; ++i) {
            this.nodes[i].setupHeightBounds();
        }
        this.heightBoundsSetup = true;
    }

    public void pushTreeChangedEvent() {
        this.pushTreeChangedEvent(new TreeChangedEvent());
    }

    public void pushTreeChangedEvent(NodeRef nodeRef) {
        this.pushTreeChangedEvent(new TreeChangedEvent((Node)nodeRef));
    }

    public void pushTreeChangedEvent(Node node, Parameter parameter, int n) {
        this.pushTreeChangedEvent(new TreeChangedEvent(node, parameter, n));
    }

    public void pushTreeChangedEvent(TreeChangedEvent treeChangedEvent) {
        if (!this.isTreeRandom) {
            throw new IllegalStateException("Attempting state change in fixed tree");
        }
        if (this.inEdit) {
            this.treeChangedEvents.add(treeChangedEvent);
        } else {
            this.listenerHelper.fireModelChanged(this, treeChangedEvent);
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        Node node = this.getNodeOfParameter((Parameter)variable);
        if (changeType == Variable.ChangeType.ALL_VALUES_CHANGED) {
            this.pushTreeChangedEvent(new TreeChangedEvent(node, (Parameter)variable, -2));
        } else {
            this.pushTreeChangedEvent(node, (Parameter)variable, n);
        }
    }

    public boolean inTreeEdit() {
        return this.inEdit;
    }

    @Override
    public Units.Type getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(Units.Type type) {
        this.units = type;
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public boolean hasNodeHeights() {
        return true;
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        return ((Node)nodeRef).getHeight();
    }

    public final double getNodeHeightUpper(NodeRef nodeRef) {
        return ((Node)nodeRef).heightParameter.getBounds().getUpperLimit(0);
    }

    public final double getNodeHeightLower(NodeRef nodeRef) {
        return ((Node)nodeRef).heightParameter.getBounds().getLowerLimit(0);
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        throw new UnsupportedOperationException("getNodeAttribute is not used for TreeModel");
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        throw new UnsupportedOperationException("getNodeAttribute is not used for TreeModel");
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        return ((Node)nodeRef).taxon;
    }

    public void setNodeTaxon(NodeRef nodeRef, Taxon taxon) {
        ((Node)nodeRef).taxon = taxon;
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        return ((Node)nodeRef).isExternal();
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        return nodeRef == this.root;
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        return ((Node)nodeRef).getChildCount();
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        return ((Node)nodeRef).getChild(n);
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        return ((Node)nodeRef).parent;
    }

    @Override
    public boolean hasBranchLengths() {
        return true;
    }

    @Override
    public double getBranchLength(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.getParent(nodeRef);
        if (nodeRef2 == null) {
            return 0.0;
        }
        return this.getNodeHeight(nodeRef2) - this.getNodeHeight(nodeRef);
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        throw new UnsupportedOperationException("getNodeRate is deprecated");
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        throw new UnsupportedOperationException("setNodeRate is deprecated");
    }

    @Override
    public NodeRef getExternalNode(int n) {
        return this.nodes[n];
    }

    @Override
    public NodeRef getInternalNode(int n) {
        return this.nodes[n + this.externalNodeCount];
    }

    @Override
    public NodeRef getNode(int n) {
        return this.nodes[n];
    }

    public NodeRef[] getNodes() {
        return this.nodes;
    }

    @Override
    public int getExternalNodeCount() {
        return this.externalNodeCount;
    }

    @Override
    public int getInternalNodeCount() {
        return this.internalNodeCount;
    }

    @Override
    public NodeRef getRoot() {
        return this.root;
    }

    @Override
    public final void setRoot(NodeRef nodeRef) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        this.root = (Node)nodeRef;
        this.pushTreeChangedEvent(this.root);
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        if (node.hasChild(node2)) {
            throw new IllegalArgumentException("Child already exists in parent");
        }
        node.addChild(node2);
        this.pushTreeChangedEvent(node);
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        node.removeChild(node2);
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean beginTreeEdit() {
        if (this.inEdit) {
            throw new RuntimeException("Alreading in edit transaction mode!");
        }
        this.oldRoot = this.root;
        this.inEdit = true;
        return false;
    }

    @Override
    public void endTreeEdit() {
        if (!this.inEdit) {
            throw new RuntimeException("Not in edit transaction mode!");
        }
        this.inEdit = false;
        for (TreeChangedEvent treeChangedEvent : this.treeChangedEvents) {
            this.listenerHelper.fireModelChanged(this, treeChangedEvent);
        }
        this.treeChangedEvents.clear();
    }

    public void checkTreeIsValid() throws MutableTree.InvalidTreeException {
        for (Node node : this.nodes) {
            if (node.heightParameter.isWithinBounds()) continue;
            throw new MutableTree.InvalidTreeException("height parameter out of bounds");
        }
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        ((Node)nodeRef).setHeight(d);
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        throw new UnsupportedOperationException("TreeModel cannot have branch lengths set");
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        throw new UnsupportedOperationException("TreeModel does not use NodeAttributes");
    }

    @Override
    protected void storeState() {
        this.copyNodeStructure(this.storedNodes);
        this.storedRootNumber = this.root.getNumber();
    }

    @Override
    protected void restoreState() {
        Node[] nodeArray = this.storedNodes;
        this.storedNodes = this.nodes;
        this.nodes = nodeArray;
        this.root = this.nodes[this.storedRootNumber];
    }

    @Override
    protected void acceptState() {
    }

    private void copyNodeStructure(Node[] nodeArray) {
        if (this.nodes.length != nodeArray.length) {
            throw new IllegalArgumentException("Node arrays are of different lengths");
        }
        int n = this.nodes.length;
        for (int i = 0; i < n; ++i) {
            Node node = this.nodes[i];
            Node node2 = nodeArray[i];
            node2.heightParameter = node.heightParameter;
            node2.parent = node.parent != null ? this.storedNodes[node.parent.getNumber()] : null;
            node2.leftChild = node.leftChild != null ? this.storedNodes[node.leftChild.getNumber()] : null;
            node2.rightChild = node.rightChild != null ? this.storedNodes[node.rightChild.getNumber()] : null;
        }
    }

    public void adoptTreeStructure(Tree tree) {
        for (int i = this.externalNodeCount; i < this.nodeCount; ++i) {
            int n = this.nodes[i].getChildCount();
            for (int j = 0; j < n; ++j) {
                this.nodes[i].removeChild(j);
            }
        }
        this.addNodeStructure(tree, tree.getRoot());
    }

    public void adoptTreeStructure(int[] nArray, double[] dArray, int[] nArray2) {
        int n;
        int n2;
        if (this.nodeCount != nArray.length) {
            throw new RuntimeException("Incorrect number of edges provided: " + nArray.length + " versus " + this.nodeCount + " nodes.");
        }
        for (n2 = this.externalNodeCount; n2 < this.nodeCount; ++n2) {
            n = this.nodes[n2].getChildCount();
            for (int i = 0; i < n; ++i) {
                this.nodes[n2].removeChild(i);
            }
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            this.setNodeHeight(this.nodes[n2], dArray[n2]);
        }
        n2 = -1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != -1) {
                this.nodes[nArray[n]].addChild(this.nodes[n]);
                continue;
            }
            n2 = n;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == -1 || nArray2[n] != 0 || this.nodes[nArray[n]].getChild(0) == this.nodes[n]) continue;
            Node node = this.nodes[nArray[n]].removeChild(0);
            Node node2 = this.nodes[nArray[n]].removeChild(1);
            this.nodes[nArray[n]].addChild(node2);
            this.nodes[nArray[n]].addChild(node);
        }
        this.setRoot(this.nodes[n2]);
    }

    private void addNodeStructure(Tree tree, NodeRef nodeRef) {
        int n;
        Node node = null;
        node = tree.isExternal(nodeRef) ? this.nodes[this.getTaxonIndex(tree.getTaxonId(nodeRef.getNumber()))] : this.nodes[nodeRef.getNumber()];
        this.setNodeHeight(node, tree.getNodeHeight(nodeRef));
        for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
            if (tree.isExternal(tree.getChild(nodeRef, n))) {
                this.addChild(node, this.nodes[this.getTaxonIndex(tree.getTaxonId(tree.getChild(nodeRef, n).getNumber()))]);
                continue;
            }
            this.addChild(node, this.nodes[tree.getChild(nodeRef, n).getNumber()]);
        }
        this.pushTreeChangedEvent(node);
        if (!tree.isExternal(nodeRef)) {
            for (n = 0; n < tree.getChildCount(nodeRef); ++n) {
                this.addNodeStructure(tree, tree.getChild(nodeRef, n));
            }
        }
    }

    @Override
    public int getStatisticCount() {
        return super.getStatisticCount() + 1;
    }

    @Override
    public Statistic getStatistic(int n) {
        if (n == super.getStatisticCount()) {
            return this.root.heightParameter;
        }
        return super.getStatistic(n);
    }

    @Override
    public int getTaxonCount() {
        return this.getExternalNodeCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return ((Node)this.getExternalNode((int)n)).taxon;
    }

    @Override
    public String getTaxonId(int n) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getId();
        }
        return null;
    }

    @Override
    public int getTaxonIndex(String string) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getTaxonId(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (this.getTaxon(i) != taxon) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < NewTreeModel.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return NewTreeModel.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getAttribute(string);
        }
        return null;
    }

    @Override
    public int addTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a TreeModel");
    }

    @Override
    public boolean removeTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a TreeModel");
    }

    @Override
    public void setTaxonId(int n, String string) {
        throw new IllegalArgumentException("Cannot set taxon id in a TreeModel");
    }

    @Override
    public void setTaxonAttribute(int n, String string, Object object) {
        throw new IllegalArgumentException("Cannot set taxon attribute in a TreeModel");
    }

    @Override
    public void addMutableTreeListener(MutableTreeListener mutableTreeListener) {
    }

    @Override
    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.treeAttributes == null) {
            this.treeAttributes = new Attributable.AttributeHelper();
        }
        this.treeAttributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.treeAttributes == null) {
            return null;
        }
        return this.treeAttributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.treeAttributes == null) {
            return null;
        }
        return this.treeAttributes.getAttributeNames();
    }

    public final String getNewick() {
        return TreeUtils.newick(this);
    }

    @Override
    public String toString() {
        return this.getNewick();
    }

    @Override
    public Tree getCopy() {
        throw new UnsupportedOperationException("please don't call this function");
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet");
    }

    public Node getNodeOfParameter(Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter is null!");
        }
        for (Node node : this.nodes) {
            if (node.heightParameter != parameter) continue;
            return node;
        }
        throw new RuntimeException("Parameter not found in any nodes:" + parameter.getId() + " " + parameter.hashCode());
    }

    public Parameter getRootHeightParameter() {
        return this.root.heightParameter;
    }

    public Parameter createNodeHeightsParameter(boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (!bl) {
            throw new UnsupportedOperationException("A node height parameter without the root is not currently implemented");
        }
        this.checkValidFlags(bl, bl2, bl3);
        CompoundParameter compoundParameter = new CompoundParameter("nodeHeights(" + this.getId() + ")");
        for (n = this.externalNodeCount; n < this.nodeCount; ++n) {
            if ((!bl || this.nodes[n] != this.root) && (!bl2 || this.nodes[n] == this.root)) continue;
            compoundParameter.addParameter(this.nodes[n].heightParameter);
        }
        if (bl3) {
            for (n = 0; n < this.externalNodeCount; ++n) {
                compoundParameter.addParameter(this.nodes[n].heightParameter);
            }
        }
        return compoundParameter;
    }

    public Parameter getLeafHeightParameter(NodeRef nodeRef) {
        if (!this.isExternal(nodeRef)) {
            throw new RuntimeException("only leaves can be used with getLeafHeightParameter");
        }
        this.isTipDateSampled = true;
        return this.nodes[nodeRef.getNumber()].heightParameter;
    }

    private void checkValidFlags(boolean bl, boolean bl2, boolean bl3) {
        if (!(bl || bl2 || bl3)) {
            throw new IllegalArgumentException("At least one of rootNode, internalNodes or leafNodes must be true");
        }
    }

    @Override
    public void addKeyword(String string) {
        this.keywords.add(string);
    }

    @Override
    public List<String> getKeywords() {
        return this.keywords;
    }

    public boolean isTipDateSampled() {
        return this.isTipDateSampled;
    }

    @Override
    public boolean isVariable() {
        return this.isTreeRandom;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Sampling tip dates model";
    }

    @Override
    public List<Citation> getCitations() {
        if (this.isTipDateSampled()) {
            return Arrays.asList(new Citation(new Author[]{new Author("B", "Shapiro"), new Author("SYW", "Ho"), new Author("AJ", "Drummond"), new Author("MA", "Suchard"), new Author("OG", "Pybus"), new Author("A", "Rambaut")}, "A Bayesian phylogenetic method to estimate unknown sequence ages", 2010, "Mol Biol Evol", 28, 879, 887, "10.1093/molbev/msq262"), new Citation(new Author[]{new Author("AJ", "Drummond")}, "PhD Thesis", 2002, "University of Auckland", ""));
        }
        return Collections.EMPTY_LIST;
    }

    public class Node
    implements NodeRef {
        public Node parent = null;
        public Node leftChild = null;
        public Node rightChild = null;
        private int number;
        public Parameter heightParameter;
        public Taxon taxon = null;

        public Node() {
            this.heightParameter = null;
            this.number = 0;
            this.taxon = null;
        }

        public Node(Tree tree, NodeRef nodeRef) {
            this.heightParameter = new Parameter.Default(tree.getNodeHeight(nodeRef));
            NewTreeModel.this.addVariable(this.heightParameter);
            this.number = nodeRef.getNumber();
            this.taxon = tree.getNodeTaxon(nodeRef);
            this.heightParameter.setId(NewTreeModel.this.getId() + "." + this.number);
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                this.addChild(new Node(tree, tree.getChild(nodeRef, i)));
            }
        }

        public final void setupHeightBounds() {
            this.heightParameter.addBounds(new NodeHeightBounds(this.heightParameter));
        }

        private void setParameterValues(Parameter parameter, int n, double[] dArray) {
            if (dArray != null && dArray.length > 0) {
                for (int i = 0; i < n; ++i) {
                    if (dArray.length == n) {
                        parameter.setParameterValue(i, dArray[i]);
                        continue;
                    }
                    parameter.setParameterValue(i, dArray[0]);
                }
            }
        }

        public final double getHeight() {
            return this.heightParameter.getParameterValue(0);
        }

        public final void setHeight(double d) {
            this.heightParameter.setParameterValue(0, d);
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public void setNumber(int n) {
            this.number = n;
        }

        public final int getChildCount() {
            int n = 0;
            if (this.leftChild != null) {
                ++n;
            }
            if (this.rightChild != null) {
                ++n;
            }
            return n;
        }

        public Node getChild(int n) {
            if (n == 0) {
                return this.leftChild;
            }
            if (n == 1) {
                return this.rightChild;
            }
            throw new IllegalArgumentException("TreeModel.Nodes can only have 2 children");
        }

        public boolean hasChild(Node node) {
            return this.leftChild == node || this.rightChild == node;
        }

        public void addChild(Node node) {
            if (this.leftChild == null) {
                this.leftChild = node;
            } else if (this.rightChild == null) {
                this.rightChild = node;
            } else {
                throw new IllegalArgumentException("TreeModel.Nodes can only have 2 children");
            }
            node.parent = this;
        }

        public Node removeChild(Node node) {
            if (this.leftChild == node) {
                this.leftChild = null;
            } else if (this.rightChild == node) {
                this.rightChild = null;
            } else {
                throw new IllegalArgumentException("Unknown child node");
            }
            node.parent = null;
            return node;
        }

        public Node removeChild(int n) {
            Node node;
            if (n == 0) {
                node = this.leftChild;
                this.leftChild = null;
            } else if (n == 1) {
                node = this.rightChild;
                this.rightChild = null;
            } else {
                throw new IllegalArgumentException("TreeModel.Nodes can only have 2 children");
            }
            node.parent = null;
            return node;
        }

        public boolean hasNoChildren() {
            return this.leftChild == null && this.rightChild == null;
        }

        public boolean isExternal() {
            return this.hasNoChildren();
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public String toString() {
            return "node " + this.number + ", height=" + this.getHeight() + (this.taxon != null ? ": " + this.taxon.getId() : "");
        }
    }

    public class TreeChangedEvent
    implements dr.evomodel.tree.TreeChangedEvent {
        static final int CHANGE_IN_ALL_INTERNAL_NODES = -2;
        final Node node;
        final Parameter parameter;
        final int index;
        final boolean nodeOrderChanged;

        public TreeChangedEvent() {
            this(null, null, -1, false);
        }

        public TreeChangedEvent(Node node) {
            this(node, null, -1, false);
        }

        public TreeChangedEvent(Node node, Parameter parameter, int n) {
            this(node, parameter, -n, false);
        }

        public TreeChangedEvent(Node node, Parameter parameter, int n, boolean bl) {
            this.node = node;
            this.parameter = parameter;
            this.index = n;
            this.nodeOrderChanged = bl;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        @Override
        public boolean isTreeChanged() {
            return this.parameter == null;
        }

        @Override
        public boolean isNodeChanged() {
            return this.node != null;
        }

        @Override
        public boolean isNodeOrderChanged() {
            return this.nodeOrderChanged;
        }

        @Override
        public boolean isNodeParameterChanged() {
            return this.parameter != null;
        }

        @Override
        public boolean isHeightChanged() {
            return this.parameter == this.node.heightParameter;
        }

        @Override
        public boolean isOnlyHeightChanged() {
            return false;
        }

        public boolean areAllInternalHeightsChanged() {
            if (this.parameter != null) {
                return this.parameter == this.node.heightParameter && this.index == -2;
            }
            return false;
        }
    }

    private class NodeHeightBounds
    implements Bounds<Double> {
        private Parameter nodeHeightParameter = null;

        public NodeHeightBounds(Parameter parameter) {
            this.nodeHeightParameter = parameter;
        }

        @Override
        public Double getUpperLimit(int n) {
            Node node = NewTreeModel.this.getNodeOfParameter(this.nodeHeightParameter);
            if (node.isRoot()) {
                return Double.POSITIVE_INFINITY;
            }
            return node.parent.getHeight();
        }

        @Override
        public Double getLowerLimit(int n) {
            Node node = NewTreeModel.this.getNodeOfParameter(this.nodeHeightParameter);
            if (node.isExternal()) {
                return 0.0;
            }
            return Math.max(node.leftChild.getHeight(), node.rightChild.getHeight());
        }

        @Override
        public int getBoundsDimension() {
            return 1;
        }
    }
}

