/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ExponentialSawtooth;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;

public class ExponentialSawtoothModel
extends DemographicModel {
    Parameter N0Parameter = null;
    Parameter growthRateParameter = null;
    Parameter wavelengthParameter = null;
    Parameter offsetParameter = null;
    ExponentialSawtooth expSaw = null;

    public ExponentialSawtoothModel(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        this("exponentialSawtooth", parameter, parameter2, parameter3, parameter4, type);
    }

    public ExponentialSawtoothModel(String string, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, Units.Type type) {
        super(string);
        this.expSaw = new ExponentialSawtooth(type);
        this.N0Parameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.MIN_VALUE, 1));
        this.growthRateParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, -1.7976931348623157E308, 1));
        this.wavelengthParameter = parameter3;
        this.addVariable(parameter3);
        parameter3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.MIN_VALUE, 1));
        this.offsetParameter = parameter4;
        this.addVariable(parameter4);
        parameter4.addBounds(new Parameter.DefaultBounds(1.0, -1.0, 1));
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        this.expSaw.setN0(this.N0Parameter.getParameterValue(0));
        this.expSaw.setGrowthRate(this.growthRateParameter.getParameterValue(0));
        this.expSaw.setWavelength(this.wavelengthParameter.getParameterValue(0));
        double d = this.offsetParameter.getParameterValue(0);
        if (d < 0.0) {
            d += 1.0;
        }
        this.expSaw.setOffset(d);
        return this.expSaw;
    }
}

