/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.coalescent.OldAbstractCoalescentLikelihood;
import dr.evomodel.tree.TreeModel;

public class ExponentialProductSufficientStatisticsLikelihood
extends OldAbstractCoalescentLikelihood {
    public static final boolean FIXED_TREE = false;
    private TreeModel treeModel;
    private double[] posteriorMeans;
    protected int fieldLength;
    protected double[] coalescentIntervals;
    protected double[] sufficientStatistics;

    public ExponentialProductSufficientStatisticsLikelihood(TreeModel treeModel, double[] dArray) {
        super("ExponentialProductSufficientStatisticsLikelihood");
        this.treeModel = treeModel;
        this.posteriorMeans = dArray;
        this.tree = treeModel;
        this.addModel((TreeModel)this.tree);
        this.fieldLength = dArray.length;
        this.wrapSetupIntervals();
        this.coalescentIntervals = new double[this.fieldLength];
        this.sufficientStatistics = new double[this.fieldLength];
    }

    protected void wrapSetupIntervals() {
        this.setupIntervals();
    }

    protected void setupSufficientStatistics() {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.getIntervalCount(); ++i) {
            d += this.getInterval(i);
            d2 += this.getInterval(i) * (double)this.getLineageCount(i) * (double)(this.getLineageCount(i) - 1);
            if (this.getIntervalType(i) != OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT) continue;
            this.coalescentIntervals[n] = d;
            this.sufficientStatistics[n] = d2 / 2.0;
            ++n;
            d = 0.0;
            d2 = 0.0;
        }
    }

    private void makeIntervalsKnown() {
        if (!this.intervalsKnown) {
            this.wrapSetupIntervals();
            this.intervalsKnown = true;
        }
    }

    @Override
    public double calculateLogLikelihood() {
        this.tree = this.treeModel;
        this.makeIntervalsKnown();
        this.setupSufficientStatistics();
        double d = 0.0;
        double[] dArray = this.posteriorMeans;
        for (int i = 0; i < this.fieldLength; ++i) {
            d += -dArray[i] - this.sufficientStatistics[i] * Math.exp(-dArray[i]);
        }
        return d;
    }

    protected boolean getLikelihoodKnown() {
        return false;
    }
}

