/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.antigenic;

import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class DirichletProcessGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String DIRICHLET_PROCESS_OPERATOR = "dirichletProcessOperator";
    private final int N;
    private final int K;
    private final Parameter chiParameter;
    private final Likelihood modelLikelihood;
    private Parameter clusteringParameter = null;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String CHI = "chi";
        public static final String LIKELIHOOD = "likelihood";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule("chi", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("likelihood", new XMLSyntaxRule[]{new ElementRule(Likelihood.class)}, true), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return DirichletProcessGibbsOperator.DIRICHLET_PROCESS_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild(CHI);
            Likelihood likelihood = null;
            if (xMLObject.hasChildNamed(LIKELIHOOD)) {
                likelihood = (Likelihood)xMLObject.getElementFirstChild(LIKELIHOOD);
            }
            return new DirichletProcessGibbsOperator(parameter, parameter2, likelihood, d);
        }

        @Override
        public String getParserDescription() {
            return "An operator that picks a new allocation of an item to a cluster under the Dirichlet process.";
        }

        @Override
        public Class getReturnType() {
            return DirichletProcessGibbsOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public DirichletProcessGibbsOperator(Parameter parameter, Parameter parameter2, Likelihood likelihood, double d) {
        this.clusteringParameter = parameter;
        this.N = parameter.getDimension();
        this.chiParameter = parameter2;
        this.modelLikelihood = likelihood;
        this.K = this.N;
        this.setWeight(d);
    }

    @Override
    public Parameter getParameter() {
        return this.clusteringParameter;
    }

    public Variable getVariable() {
        return this.clusteringParameter;
    }

    @Override
    public final double doOperation() {
        int n;
        int n2 = MathUtils.nextInt(this.clusteringParameter.getDimension());
        int[] nArray = new int[this.N];
        int n3 = this.K;
        for (int i = 0; i < this.clusteringParameter.getDimension(); ++i) {
            int n4 = (int)this.clusteringParameter.getParameterValue(i);
            if (i == n2) continue;
            int n5 = n4;
            nArray[n5] = nArray[n5] + 1;
            if (nArray[n4] != 1) continue;
            --n3;
        }
        double d = this.chiParameter.getParameterValue(0);
        double d2 = d / (((double)(this.N - 1) + d) * (double)n3);
        double[] dArray = new double[this.K];
        for (n = 0; n < this.K; ++n) {
            double d3 = nArray[n] == 0 ? d2 : (double)nArray[n] / ((double)(this.N - 1) + d);
            dArray[n] = Math.log(d3);
        }
        if (this.modelLikelihood != null) {
            n = 0;
            while (n < this.K) {
                this.clusteringParameter.setParameterValue(n2, n);
                int n6 = n++;
                dArray[n6] = dArray[n6] + this.modelLikelihood.getLogLikelihood();
            }
        }
        this.rescale(dArray);
        this.exp(dArray);
        n = MathUtils.randomChoicePDF(dArray);
        this.clusteringParameter.setParameterValue(n2, n);
        return 0.0;
    }

    private void exp(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.exp(dArray[i]);
        }
    }

    private void rescale(double[] dArray) {
        double d = this.max(dArray);
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] - d;
        }
    }

    private double max(double[] dArray) {
        double d = dArray[0];
        for (double d2 : dArray) {
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    @Override
    public final String getOperatorName() {
        return "dirichletProcessOperator(" + this.clusteringParameter.getId() + "|" + this.chiParameter.getId() + ")";
    }

    public final void optimize(double d) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public boolean isOptimizing() {
        return false;
    }

    public void setOptimizing(boolean bl) {
        throw new RuntimeException("This operator cannot be optimized!");
    }

    public double getMinimumAcceptanceLevel() {
        return 0.1;
    }

    public double getMaximumAcceptanceLevel() {
        return 0.4;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.2;
    }

    public double getMaximumGoodAcceptanceLevel() {
        return 0.3;
    }

    public String getPerformanceSuggestion() {
        if (this.getAcceptanceProbability() < this.getMinimumAcceptanceLevel()) {
            return "";
        }
        if (this.getAcceptanceProbability() > this.getMaximumAcceptanceLevel()) {
            return "";
        }
        return "";
    }

    public String toString() {
        return "dirichletProcessOperator(" + this.clusteringParameter.getId() + ")";
    }

    public int getStepCount() {
        return 1;
    }
}

