/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.FlexibleNode;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.util.Attributable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FlexibleTree
implements MutableTree {
    protected String id = null;
    private Attributable.AttributeHelper attributes = null;
    private final ArrayList<MutableTreeListener> mutableTreeListeners = new ArrayList();
    private final ArrayList<MutableTaxonListListener> mutableTaxonListListeners = new ArrayList();
    FlexibleNode root;
    FlexibleNode[] nodes = null;
    int nodeCount;
    int externalNodeCount;
    int internalNodeCount;
    private Units.Type units = Units.Type.SUBSTITUTIONS;
    boolean inEdit = false;
    boolean heightsKnown = false;
    boolean lengthsKnown = false;

    public FlexibleTree() {
        this.root = null;
    }

    public FlexibleTree(Tree tree) {
        this(tree, false);
    }

    public FlexibleTree(Tree tree, boolean bl) {
        this.setUnits(tree.getUnits());
        this.root = new FlexibleNode(tree, tree.getRoot(), bl);
        this.nodeCount = tree.getNodeCount();
        this.internalNodeCount = tree.getInternalNodeCount();
        this.externalNodeCount = tree.getExternalNodeCount();
        this.nodes = new FlexibleNode[this.nodeCount];
        FlexibleNode flexibleNode = this.root;
        do {
            if ((flexibleNode = (FlexibleNode)TreeUtils.postorderSuccessor(this, flexibleNode)).getNumber() >= this.externalNodeCount && flexibleNode.isExternal() || flexibleNode.getNumber() < this.externalNodeCount && !flexibleNode.isExternal()) {
                throw new RuntimeException("Error cloning tree: node numbers are incompatible");
            }
            this.nodes[flexibleNode.getNumber()] = flexibleNode;
        } while (flexibleNode != this.root);
        this.heightsKnown = tree.hasNodeHeights();
        this.lengthsKnown = tree.hasBranchLengths();
    }

    public FlexibleTree(FlexibleNode flexibleNode) {
        this(flexibleNode, true, true, null);
    }

    public FlexibleTree(FlexibleNode flexibleNode, boolean bl, boolean bl2) {
        this(flexibleNode, bl, bl2, null);
    }

    public FlexibleTree(FlexibleNode flexibleNode, Map<Taxon, Integer> map) {
        this(flexibleNode, true, true, map);
    }

    public FlexibleTree(FlexibleNode flexibleNode, boolean bl, boolean bl2, Map<Taxon, Integer> map) {
        this.adoptNodes(flexibleNode, map);
        this.heightsKnown = bl;
        this.lengthsKnown = bl2;
    }

    @Override
    public Tree getCopy() {
        return new FlexibleTree(this);
    }

    public void adoptTreeModelOrdering() {
        this.resolveTree();
        int n = 0;
        int n2 = this.externalNodeCount;
        FlexibleNode flexibleNode = (FlexibleNode)this.getRoot();
        do {
            if ((flexibleNode = (FlexibleNode)TreeUtils.postorderSuccessor(this, flexibleNode)).isExternal()) {
                flexibleNode.setNumber(n);
                this.nodes[n] = flexibleNode;
                ++n;
                continue;
            }
            flexibleNode.setNumber(n2);
            this.nodes[n2] = flexibleNode;
            ++n2;
        } while (flexibleNode != this.root);
    }

    protected void adoptNodes(FlexibleNode flexibleNode, Map<Taxon, Integer> map) {
        if (this.inEdit) {
            throw new RuntimeException("Mustn't be in an edit transaction to call this method!");
        }
        this.internalNodeCount = 0;
        this.externalNodeCount = 0;
        this.root = flexibleNode;
        do {
            if ((flexibleNode = (FlexibleNode)TreeUtils.postorderSuccessor(this, flexibleNode)).isExternal()) {
                ++this.externalNodeCount;
                continue;
            }
            ++this.internalNodeCount;
        } while (flexibleNode != this.root);
        this.nodeCount = this.internalNodeCount + this.externalNodeCount;
        this.nodes = new FlexibleNode[this.nodeCount];
        flexibleNode = this.root;
        int n = 0;
        int n2 = this.externalNodeCount;
        do {
            if ((flexibleNode = (FlexibleNode)TreeUtils.postorderSuccessor(this, flexibleNode)).isExternal()) {
                if (map != null && map.size() > 0) {
                    n = map.get(flexibleNode.getTaxon());
                }
                flexibleNode.setNumber(n);
                this.nodes[n] = flexibleNode;
                if (map != null && map.size() != 0) continue;
                ++n;
                continue;
            }
            flexibleNode.setNumber(n2);
            this.nodes[n2] = flexibleNode;
            ++n2;
        } while (flexibleNode != this.root);
    }

    @Override
    public final Units.Type getUnits() {
        return this.units;
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.units = type;
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount;
    }

    @Override
    public boolean hasNodeHeights() {
        return this.heightsKnown;
    }

    @Override
    public double getNodeHeight(NodeRef nodeRef) {
        if (!this.heightsKnown) {
            this.calculateNodeHeights();
        }
        return ((FlexibleNode)nodeRef).getHeight();
    }

    @Override
    public boolean hasBranchLengths() {
        return this.lengthsKnown;
    }

    @Override
    public double getBranchLength(NodeRef nodeRef) {
        if (!this.lengthsKnown) {
            this.calculateBranchLengths();
        }
        return ((FlexibleNode)nodeRef).getLength();
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        Object object = this.getNodeAttribute(nodeRef, "rate");
        if (object != null) {
            if (object instanceof Number) {
                return (Double)object;
            }
            if (object instanceof String) {
                return Double.parseDouble((String)object);
            }
        }
        return ((FlexibleNode)nodeRef).getRate();
    }

    @Override
    public Taxon getNodeTaxon(NodeRef nodeRef) {
        return ((FlexibleNode)nodeRef).getTaxon();
    }

    public void setNodeTaxon(NodeRef nodeRef, Taxon taxon) {
        ((FlexibleNode)nodeRef).setTaxon(taxon);
    }

    @Override
    public int getChildCount(NodeRef nodeRef) {
        return ((FlexibleNode)nodeRef).getChildCount();
    }

    @Override
    public boolean isExternal(NodeRef nodeRef) {
        return ((FlexibleNode)nodeRef).getChildCount() == 0;
    }

    @Override
    public boolean isRoot(NodeRef nodeRef) {
        return nodeRef == this.root;
    }

    @Override
    public NodeRef getChild(NodeRef nodeRef, int n) {
        return ((FlexibleNode)nodeRef).getChild(n);
    }

    @Override
    public NodeRef getParent(NodeRef nodeRef) {
        return ((FlexibleNode)nodeRef).getParent();
    }

    @Override
    public final NodeRef getExternalNode(int n) {
        return this.nodes[n];
    }

    @Override
    public final NodeRef getInternalNode(int n) {
        return this.nodes[n + this.externalNodeCount];
    }

    @Override
    public final NodeRef getNode(int n) {
        return this.nodes[n];
    }

    @Override
    public final int getExternalNodeCount() {
        return this.externalNodeCount;
    }

    @Override
    public final int getInternalNodeCount() {
        return this.internalNodeCount;
    }

    @Override
    public final NodeRef getRoot() {
        return this.root;
    }

    @Override
    public final void setRoot(NodeRef nodeRef) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        if (!(nodeRef instanceof FlexibleNode)) {
            throw new IllegalArgumentException();
        }
        this.root = (FlexibleNode)nodeRef;
    }

    public final double getRootHeight() {
        return this.getNodeHeight(this.root);
    }

    public final void setRootHeight(double d) {
        this.setNodeHeight(this.root, d);
        this.fireTreeChanged();
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        FlexibleNode flexibleNode = (FlexibleNode)nodeRef;
        FlexibleNode flexibleNode2 = (FlexibleNode)nodeRef2;
        if (flexibleNode.hasChild(flexibleNode2)) {
            throw new IllegalArgumentException("Child already existists in parent");
        }
        flexibleNode.addChild(flexibleNode2);
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        FlexibleNode flexibleNode = (FlexibleNode)nodeRef;
        FlexibleNode flexibleNode2 = (FlexibleNode)nodeRef2;
        for (int i = 0; i < flexibleNode.getChildCount(); ++i) {
            if (flexibleNode.getChild(i) != flexibleNode2) continue;
            flexibleNode.removeChild(i);
            return;
        }
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public boolean beginTreeEdit() {
        boolean bl = this.inEdit;
        this.inEdit = true;
        return bl;
    }

    @Override
    public void endTreeEdit() {
        this.inEdit = false;
        this.fireTreeChanged();
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        if (!this.heightsKnown) {
            this.calculateNodeHeights();
        }
        FlexibleNode flexibleNode = (FlexibleNode)nodeRef;
        flexibleNode.setHeight(d);
        this.lengthsKnown = false;
        this.fireTreeChanged();
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        if (!this.lengthsKnown) {
            this.calculateBranchLengths();
        }
        FlexibleNode flexibleNode = (FlexibleNode)nodeRef;
        flexibleNode.setLength(d);
        this.heightsKnown = false;
        this.fireTreeChanged();
    }

    public void setHeightsKnown(boolean bl) {
        this.heightsKnown = bl;
    }

    public void setLengthsKnown(boolean bl) {
        this.lengthsKnown = bl;
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        FlexibleNode flexibleNode = (FlexibleNode)nodeRef;
        flexibleNode.setRate(d);
        this.fireTreeChanged();
    }

    protected void calculateNodeHeights() {
        FlexibleNode flexibleNode;
        int n;
        if (!this.lengthsKnown) {
            throw new IllegalArgumentException("Branch lengths not known");
        }
        this.nodeLengthsToHeights((FlexibleNode)this.getRoot(), 0.0);
        double d = 0.0;
        for (n = 0; n < this.getExternalNodeCount(); ++n) {
            flexibleNode = (FlexibleNode)this.getExternalNode(n);
            if (!(flexibleNode.getHeight() > d)) continue;
            d = flexibleNode.getHeight();
        }
        for (n = 0; n < this.getNodeCount(); ++n) {
            flexibleNode = (FlexibleNode)this.getNode(n);
            flexibleNode.setHeight(d - flexibleNode.getHeight());
        }
        this.heightsKnown = true;
    }

    private void nodeLengthsToHeights(FlexibleNode flexibleNode, double d) {
        double d2 = d;
        if (flexibleNode.getLength() > 0.0) {
            d2 += flexibleNode.getLength();
        }
        flexibleNode.setHeight(d2);
        for (int i = 0; i < flexibleNode.getChildCount(); ++i) {
            this.nodeLengthsToHeights(flexibleNode.getChild(i), d2);
        }
    }

    protected void calculateBranchLengths() {
        this.nodeHeightsToLengths((FlexibleNode)this.getRoot(), this.getRootHeight());
        this.lengthsKnown = true;
    }

    private void nodeHeightsToLengths(FlexibleNode flexibleNode, double d) {
        flexibleNode.setLength(d - flexibleNode.getHeight());
        for (int i = 0; i < flexibleNode.getChildCount(); ++i) {
            this.nodeHeightsToLengths(flexibleNode.getChild(i), flexibleNode.getHeight());
        }
    }

    public void changeRoot(NodeRef nodeRef, double d) {
        FlexibleNode flexibleNode = (FlexibleNode)nodeRef;
        FlexibleNode flexibleNode2 = flexibleNode.getParent();
        double d2 = d - this.getNodeHeight(nodeRef);
        if (d2 < 0.0) {
            throw new IllegalArgumentException("New root height less than the node's height");
        }
        double d3 = this.getNodeHeight(flexibleNode2) - d;
        if (d3 < 0.0) {
            throw new IllegalArgumentException("New root height above the node's parent's height");
        }
        this.changeRoot(nodeRef, d2, d3);
    }

    public void changeRoot(NodeRef nodeRef, double d, double d2) {
        FlexibleNode flexibleNode = (FlexibleNode)nodeRef;
        FlexibleNode flexibleNode2 = flexibleNode.getParent();
        if (flexibleNode2 == null || flexibleNode2 == this.root) {
            return;
        }
        this.beginTreeEdit();
        if (!this.lengthsKnown) {
            this.calculateBranchLengths();
        }
        FlexibleNode flexibleNode3 = flexibleNode2.getParent();
        this.swapParentNode(flexibleNode2, flexibleNode3, null);
        flexibleNode2.removeChild(flexibleNode);
        this.root.addChild(flexibleNode);
        this.root.addChild(flexibleNode2);
        flexibleNode.setLength(d);
        flexibleNode2.setLength(d2);
        this.heightsKnown = false;
        this.endTreeEdit();
    }

    private void swapParentNode(FlexibleNode flexibleNode, FlexibleNode flexibleNode2, FlexibleNode flexibleNode3) {
        if (flexibleNode2 != null) {
            FlexibleNode flexibleNode4 = flexibleNode2.getParent();
            this.swapParentNode(flexibleNode2, flexibleNode4, flexibleNode);
            if (flexibleNode3 != null) {
                flexibleNode.removeChild(flexibleNode3);
                flexibleNode3.addChild(flexibleNode);
                flexibleNode.setLength(flexibleNode3.getLength());
            }
        } else {
            flexibleNode.removeChild(flexibleNode3);
            if (flexibleNode.getChildCount() > 1) {
                throw new IllegalArgumentException("Trees must be binary");
            }
            FlexibleNode flexibleNode5 = flexibleNode.getChild(0);
            flexibleNode.removeChild(flexibleNode5);
            flexibleNode3.addChild(flexibleNode5);
            flexibleNode5.setLength(flexibleNode5.getLength() + flexibleNode3.getLength());
        }
    }

    public void resolveTree() {
        for (int i = 0; i < this.getInternalNodeCount(); ++i) {
            FlexibleNode flexibleNode = (FlexibleNode)this.getInternalNode(i);
            if (flexibleNode.getChildCount() > 2) {
                this.resolveNode(flexibleNode);
                continue;
            }
            if (flexibleNode.getChildCount() != 1) continue;
            FlexibleNode flexibleNode2 = flexibleNode.getParent();
            if (flexibleNode2 != null) {
                FlexibleNode flexibleNode3 = flexibleNode.getChild(0);
                flexibleNode3.setParent(flexibleNode2);
                flexibleNode2.removeChild(flexibleNode);
                flexibleNode2.addChild(flexibleNode3);
                continue;
            }
            this.root = flexibleNode;
        }
        this.adoptNodes(this.root, null);
        this.fireTreeChanged();
    }

    private void resolveNode(FlexibleNode flexibleNode) {
        while (flexibleNode.getChildCount() > 2) {
            FlexibleNode flexibleNode2 = flexibleNode.getChild(0);
            FlexibleNode flexibleNode3 = flexibleNode.getChild(1);
            flexibleNode.removeChild(flexibleNode2);
            flexibleNode.removeChild(flexibleNode3);
            FlexibleNode flexibleNode4 = flexibleNode.getShallowCopy();
            flexibleNode4.addChild(flexibleNode2);
            flexibleNode4.addChild(flexibleNode3);
            flexibleNode4.setLength(0.0);
            flexibleNode.addChild(flexibleNode4);
        }
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        ((FlexibleNode)nodeRef).setAttribute(string, object);
        this.fireTreeChanged();
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        return ((FlexibleNode)nodeRef).getAttribute(string);
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        return ((FlexibleNode)nodeRef).getAttributeNames();
    }

    @Override
    public int getTaxonCount() {
        return this.getExternalNodeCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return ((FlexibleNode)this.getExternalNode(n)).getTaxon();
    }

    @Override
    public String getTaxonId(int n) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getId();
        }
        return ((FlexibleNode)this.getExternalNode(n)).getId();
    }

    @Override
    public int getTaxonIndex(String string) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getTaxonId(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (this.getTaxon(i) != taxon) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < FlexibleTree.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return FlexibleTree.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public Object getTaxonAttribute(int n, String string) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getAttribute(string);
        }
        return ((FlexibleNode)this.getExternalNode(n)).getAttribute(string);
    }

    @Override
    public int addTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a MutableTree");
    }

    @Override
    public boolean removeTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot remove taxon to a MutableTree");
    }

    @Override
    public void setTaxonId(int n, String string) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            taxon.setId(string);
        } else {
            ((FlexibleNode)this.getExternalNode(n)).setId(string);
        }
        this.fireTreeChanged();
        this.fireTaxaChanged();
    }

    @Override
    public void setTaxonAttribute(int n, String string, Object object) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            taxon.setAttribute(string, object);
        } else {
            ((FlexibleNode)this.getExternalNode(n)).setAttribute(string, object);
        }
        this.fireTreeChanged();
        this.fireTaxaChanged();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
        this.fireTreeChanged();
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new Attributable.AttributeHelper();
        }
        this.attributes.setAttribute(string, object);
        this.fireTreeChanged();
    }

    @Override
    public Object getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttributeNames();
    }

    @Override
    public void addMutableTreeListener(MutableTreeListener mutableTreeListener) {
        this.mutableTreeListeners.add(mutableTreeListener);
    }

    private void fireTreeChanged() {
        for (MutableTreeListener mutableTreeListener : this.mutableTreeListeners) {
            mutableTreeListener.treeChanged(this);
        }
    }

    @Override
    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
        this.mutableTaxonListListeners.add(mutableTaxonListListener);
    }

    private void fireTaxaChanged() {
        for (MutableTaxonListListener mutableTaxonListListener : this.mutableTaxonListListeners) {
            mutableTaxonListListener.taxaChanged(this);
        }
    }

    public String toString() {
        return TreeUtils.newick(this);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Tree)) {
            throw new IllegalArgumentException("FlexibleTree.equals can only compare instances of Tree");
        }
        return TreeUtils.equal(this, (Tree)object);
    }
}

