/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.colouring;

import dr.evolution.colouring.ColourChangeMatrix;
import dr.evolution.colouring.ColourSampler;
import dr.evolution.colouring.TreeColouring;
import dr.evolution.tree.ColourChange;
import dr.evolution.tree.Tree;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class TwoColourSampler
implements ColourSampler {
    public int getColourCount() {
        return 2;
    }

    public TreeColouring sampleTreeColouring(Tree tree, ColourChangeMatrix colourChangeMatrix, double[] dArray) {
        return null;
    }

    private final double conditionalSurvivalProbability(int n, double d, int n2, double d2, double[] dArray) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = dArray[0] + dArray[1];
        if (d < 0.0 || d > d2) {
            throw new IllegalArgumentException("v must be non-negative and not exceed t\n v=" + d + " t=" + d2);
        }
        if (n == n2) {
            d6 = dArray[0] * dArray[1];
            d5 = -d6;
            d4 = dArray[1 - n];
            d3 = dArray[n];
        } else {
            d6 = dArray[1 - n2];
            d5 = dArray[1 - n];
            d4 = 1.0;
            d3 = -1.0;
        }
        double d8 = (d5 * d4 - d6 * d3) / (d4 * d3 * -d7);
        double d9 = Math.pow(d4 * Math.exp(-d7 * d2) + d3, -d8);
        return d9 * Math.exp(d5 * d / d3) * Math.pow(d3 + d4 * Math.exp(-d7 * (d2 - d)), d8);
    }

    private double randomConditionalSurvivalTime(int n, int n2, double d, double[] dArray) throws NoEventException {
        double d2 = MathUtils.nextDouble();
        double d3 = 0.0;
        double d4 = d;
        double d5 = 1.0 - d2;
        double d6 = this.conditionalSurvivalProbability(n, d, n2, d, dArray) - d2;
        if (d6 >= 0.0) {
            if (n != n2) {
                throw new IllegalArgumentException("Problem in randomConditionalSurvivalTime for x=" + n + ", y=" + n2 + " t=" + d + " U=" + d2 + "fRight=" + d6);
            }
            throw new NoEventException();
        }
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        double d10 = d6;
        while (Math.abs(d7 - d8) > 1.0E-9) {
            double d11 = d7 - d9 / ((d10 - d9) / (d8 - d7));
            if (d3 >= d11 || d11 >= d4) {
                d11 = d3 - d5 / ((d6 - d5) / (d4 - d3));
            }
            double d12 = this.conditionalSurvivalProbability(n, d11, n2, d, dArray) - d2;
            d8 = d7;
            d10 = d9;
            d7 = d11;
            d9 = d12;
            if (d12 < 0.0) {
                d4 = d11;
                d6 = d12;
                continue;
            }
            d3 = d11;
            d5 = d12;
        }
        return d7;
    }

    public ColourChange randomConditionalMigrationEvent(int n, double d, int n2, double d2, double[] dArray) throws NoEventException {
        if (d < d2) {
            throw new IllegalArgumentException("currentHeight " + d + " is below childHeight=" + d2);
        }
        double d3 = this.randomConditionalSurvivalTime(n, n2, d - d2, dArray);
        return new ColourChange(d - d3, 1 - n);
    }

    public List<ColourChange> sampleConditionalMigrationEvents2(int n, double d, int n2, double d2, double[] dArray) {
        ArrayList<ColourChange> arrayList = new ArrayList<ColourChange>();
        if (d < d2) {
            throw new IllegalArgumentException("sampleConditionalMigrationEvents: parentHeight=" + d + " childHeight=" + d2 + ", not good.");
        }
        try {
            int n3 = n;
            double d3 = d;
            while (true) {
                ColourChange colourChange = this.randomConditionalMigrationEvent(n3, d3, n2, d2, dArray);
                d3 = colourChange.getTime();
                n3 = colourChange.getColourAbove();
                arrayList.add(colourChange);
            }
        }
        catch (NoEventException noEventException) {
            this.reverseColourChangeList(arrayList, n);
            return arrayList;
        }
    }

    public List<ColourChange> sampleConditionalMigrationEvents(int n, double d, int n2, double d2, double[] dArray) {
        int n3;
        ArrayList<ColourChange> arrayList = new ArrayList<ColourChange>();
        do {
            arrayList.clear();
            n3 = n;
            double d3 = d;
            do {
                double d4;
                double d5 = dArray[1 - n3];
                double d6 = MathUtils.nextDouble();
                if (n != n2 && arrayList.size() == 0) {
                    d4 = Math.exp(-d5 * (d - d2));
                    d6 = d4 + d6 * (1.0 - d4);
                }
                if (!((d3 -= (d4 = -Math.log(d6) / d5)) > d2)) continue;
                n3 = 1 - n3;
                arrayList.add(new ColourChange(d3, n3));
            } while (d3 > d2);
        } while (n3 != n2);
        this.reverseColourChangeList(arrayList, n);
        return arrayList;
    }

    public double migrationEventProposalDensity(int n, int n2, double d, double[] dArray) {
        if (n == n2) {
            return Math.exp(-d * dArray[1 - n]);
        }
        return Math.exp(-d * dArray[1 - n]) * dArray[1 - n];
    }

    public final double[] equilibrium(double[] dArray) {
        double d = dArray[0] + dArray[1];
        return new double[]{dArray[0] / d, dArray[1] / d};
    }

    protected final void reverseColourChangeList(List<ColourChange> list, int n) {
        Collections.reverse(list);
        for (int i = 0; i < list.size(); ++i) {
            int n2 = i < list.size() - 1 ? list.get(i + 1).getColourAbove() : n;
            list.get(i).setColourAbove(n2);
        }
    }

    class NoEventException
    extends Exception {
        private static final long serialVersionUID = -6860022343065166240L;

        NoEventException() {
        }
    }
}

