/*
 * Decompiled with CFR 0.152.
 */
package dmLab.discretizer.chiMerge;

public final class ChiMerge {
    private int numberOfValues;
    private int[] groupsTable;
    private int currentGroupsNumber;
    private float[][] couplesTable;
    private float minChi;
    private int minChiPointer;

    public final float getMinChi() {
        return this.minChi;
    }

    public ChiMerge(float[] attributeArray) {
        this.currentGroupsNumber = this.numberOfValues = attributeArray.length;
        this.groupsTable = new int[this.numberOfValues];
        this.couplesTable = new float[this.numberOfValues - 1][3];
        int i = 0;
        while (i < this.numberOfValues) {
            int n = i++;
            this.groupsTable[n] = n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void createCouples() {
        void var1_1;
        int CouplesTablePointer = 0;
        this.couplesTable[0][0] = this.groupsTable[0];
        int PreviousValue = this.groupsTable[0];
        for (int i = 1; i < this.numberOfValues; ++i) {
            if (PreviousValue != this.groupsTable[i]) {
                this.couplesTable[CouplesTablePointer++][1] = this.groupsTable[i];
            }
            if (CouplesTablePointer >= this.numberOfValues - 1) continue;
            this.couplesTable[CouplesTablePointer][0] = this.groupsTable[i];
            PreviousValue = this.groupsTable[i];
        }
        this.currentGroupsNumber = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final float calculateChi2(int[] NumberOfPositives, int[] NumberOfNegatives) {
        this.minChi = 1.0f;
        for (int i = 0; i < this.currentGroupsNumber; ++i) {
            void var3_4;
            float e0Second;
            float e1Second;
            float e0First;
            float all;
            float e1First;
            float PositivesForFirstGroup = 0.0f;
            float NegativesForFirstGroup = 0.0f;
            float PositivesForSecondGroup = 0.0f;
            float NegativesForSecondGroup = 0.0f;
            this.couplesTable[i][2] = 0.0f;
            for (int j = 0; j < this.numberOfValues; ++j) {
                if ((float)this.groupsTable[j] == this.couplesTable[i][0]) {
                    PositivesForFirstGroup += (float)NumberOfPositives[j];
                    NegativesForFirstGroup += (float)NumberOfNegatives[j];
                    continue;
                }
                if ((float)this.groupsTable[j] == this.couplesTable[i][1]) {
                    PositivesForSecondGroup += (float)NumberOfPositives[j];
                    NegativesForSecondGroup += (float)NumberOfNegatives[j];
                    continue;
                }
                if ((float)this.groupsTable[j] > this.couplesTable[i][1]) break;
            }
            if ((e1First = (PositivesForFirstGroup + NegativesForFirstGroup) * (PositivesForFirstGroup + PositivesForSecondGroup) / (all = PositivesForFirstGroup + NegativesForFirstGroup + PositivesForSecondGroup + NegativesForSecondGroup)) == 0.0f) {
                e1First = 0.1f;
            }
            if ((e0First = (PositivesForFirstGroup + NegativesForFirstGroup) * (NegativesForFirstGroup + NegativesForSecondGroup) / all) == 0.0f) {
                e0First = 0.1f;
            }
            if ((e1Second = (PositivesForSecondGroup + NegativesForSecondGroup) * (PositivesForFirstGroup + PositivesForSecondGroup) / all) == 0.0f) {
                e1Second = 0.1f;
            }
            if ((e0Second = (PositivesForSecondGroup + NegativesForSecondGroup) * (NegativesForFirstGroup + NegativesForSecondGroup) / all) == 0.0f) {
                e0Second = 0.1f;
            }
            float[] fArray = this.couplesTable[i];
            fArray[2] = (float)((double)fArray[2] + Math.pow((double)(var3_4 - e1First), 2.0) / (double)e1First);
            float[] fArray2 = this.couplesTable[i];
            fArray2[2] = (float)((double)fArray2[2] + Math.pow(NegativesForFirstGroup - e0First, 2.0) / (double)e0First);
            float[] fArray3 = this.couplesTable[i];
            fArray3[2] = (float)((double)fArray3[2] + Math.pow(PositivesForSecondGroup - e1Second, 2.0) / (double)e1Second);
            float[] fArray4 = this.couplesTable[i];
            fArray4[2] = (float)((double)fArray4[2] + Math.pow(NegativesForSecondGroup - e0Second, 2.0) / (double)e0Second);
            if (!(this.couplesTable[i][2] < this.minChi)) continue;
            this.minChi = this.couplesTable[i][2];
            this.minChiPointer = i;
        }
        return this.minChi;
    }

    public final int defineNewGroup() {
        for (int j = 0; j < this.numberOfValues; ++j) {
            if (this.groupsTable[j] == (int)this.couplesTable[this.minChiPointer][1]) {
                this.groupsTable[j] = (int)this.couplesTable[this.minChiPointer][0];
                continue;
            }
            if ((float)this.groupsTable[j] > this.couplesTable[this.minChiPointer][1]) break;
        }
        return --this.currentGroupsNumber;
    }

    /*
     * WARNING - void declaration
     */
    public final float[] setRanges(float[] discTable, float[] attributeArray) {
        void var1_1;
        int prevNumber = 0;
        int whichRange = 0;
        for (int i = 0; i < this.numberOfValues; ++i) {
            if (this.groupsTable[i] == prevNumber) continue;
            discTable[whichRange++] = (attributeArray[i] + attributeArray[i - 1]) / 2.0f;
            prevNumber = this.groupsTable[i];
        }
        return var1_1;
    }
}

