/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.EntropyBasedSplitCrit;
import weka.core.RevisionUtils;
import weka.core.Utils;

public final class EntropySplitCrit
extends EntropyBasedSplitCrit {
    private static final long serialVersionUID = 5986252682266803935L;

    @Override
    public final double splitCritValue(Distribution bags) {
        return this.newEnt(bags);
    }

    @Override
    public final double splitCritValue(Distribution train, Distribution test) {
        double result = 0.0;
        int numClasses = 0;
        int j = 0;
        while (j < test.numClasses()) {
            if (Utils.gr(train.perClass(j), 0.0) || Utils.gr(test.perClass(j), 0.0)) {
                ++numClasses;
            }
            ++j;
        }
        int i = 0;
        while (i < test.numBags()) {
            if (Utils.gr(test.perBag(i), 0.0)) {
                j = 0;
                while (j < test.numClasses()) {
                    if (Utils.gr(test.perClassPerBag(i, j), 0.0)) {
                        result -= test.perClassPerBag(i, j) * Math.log(train.perClassPerBag(i, j) + 1.0);
                    }
                    ++j;
                }
                result += test.perBag(i) * Math.log(train.perBag(i) + (double)numClasses);
            }
            ++i;
        }
        return result / log2;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.8 $");
    }
}

