/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferentprec;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.alldifferentprec.FilterAllDiffPrec;
import org.chocosolver.solver.constraints.nary.alldifferentprec.PropAllDiffPrec;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.objects.graphs.DirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;

public class GreedyBoundSupport
extends FilterAllDiffPrec {
    private final boolean rcFiltering;
    private final ISet instVars;
    private final ISet notInstVars;
    private final ISet instValues;
    private final ISet availableVars;
    private final ISet tmp;
    private final int n;
    private int min;
    private int max;
    private final int[] mins;
    private final int[] maxs;
    private final int[] assign;
    private int candidate;
    private int nextAvailableValue;

    public GreedyBoundSupport(IntVar[] variables, boolean[][] precedence) {
        this(variables, precedence, false);
    }

    public GreedyBoundSupport(IntVar[] variables, boolean[][] precedence, boolean rcFiltering) {
        super(variables, precedence);
        this.rcFiltering = rcFiltering;
        this.instVars = SetFactory.makeBitSet(0);
        this.notInstVars = SetFactory.makeBitSet(0);
        this.instValues = SetFactory.makeBitSet(0);
        this.availableVars = SetFactory.makeBitSet(0);
        this.tmp = SetFactory.makeBitSet(0);
        this.n = variables.length;
        this.mins = new int[this.n];
        this.maxs = new int[this.n];
        this.assign = new int[this.n];
    }

    @Override
    public PropagatorPriority getPriority() {
        return PropagatorPriority.QUADRATIC;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    private boolean initDomains(int var, int val) {
        this.mins[var] = val;
        this.maxs[var] = val;
        for (int i = 0; i < this.n; ++i) {
            if (i == var) continue;
            if (this.precedence[i][var]) {
                this.mins[i] = this.variables[i].getLB();
                this.maxs[i] = Math.min(val - 1, this.variables[i].getUB());
            } else if (this.precedence[var][i]) {
                this.mins[i] = Math.max(val + 1, this.variables[i].getLB());
                this.maxs[i] = this.variables[i].getUB();
            } else {
                this.mins[i] = this.variables[i].getLB();
                if (this.mins[i] == val) {
                    this.mins[i] = Math.max(val + 1, this.variables[i].getLB());
                }
                this.maxs[i] = this.variables[i].getUB();
                if (this.maxs[i] == val) {
                    this.maxs[i] = Math.min(val - 1, this.variables[i].getUB());
                }
            }
            if (this.mins[i] <= this.maxs[i]) continue;
            return false;
        }
        return true;
    }

    private boolean updateBounds(DirectedGraph precedenceGraph, int[] topologicalTraversal, boolean lb) {
        for (int i = 0; i < topologicalTraversal.length; ++i) {
            ISetIterator it;
            int var;
            int n = var = lb ? topologicalTraversal[i] : topologicalTraversal[topologicalTraversal.length - 1 - i];
            if (this.mins[var] > this.maxs[var]) {
                return false;
            }
            ISetIterator iSetIterator = it = lb ? precedenceGraph.getSuccessorsOf(var).iterator() : precedenceGraph.getPredecessorsOf(var).iterator();
            while (it.hasNext()) {
                int v = it.nextInt();
                if (this.mins[v] > this.maxs[v]) {
                    return false;
                }
                if ((!lb || this.mins[v] > this.mins[var]) && (lb || this.maxs[v] < this.maxs[var])) continue;
                if (lb) {
                    this.mins[v] = this.mins[var] + 1;
                } else {
                    this.maxs[v] = this.maxs[var] - 1;
                }
                if (this.mins[v] <= this.maxs[v]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean containsPrecOf(ISet set, int value, DirectedGraph precedenceGraph) {
        ISetIterator it = set.iterator();
        while (it.hasNext()) {
            int i = it.nextInt();
            if (!precedenceGraph.getPredecessorsOf(value).contains(i)) continue;
            return true;
        }
        return false;
    }

    private void addAvailableValues(int var, int v) {
        if (v == this.nextAvailableValue) {
            this.nextAvailableValue = Integer.MAX_VALUE;
            ISetIterator it = this.notInstVars.iterator();
            while (it.hasNext()) {
                int i = it.nextInt();
                if (this.mins[i] == v && i != var) {
                    this.availableVars.add(i);
                    this.tmp.add(i);
                    continue;
                }
                if (this.mins[i] <= v) continue;
                this.nextAvailableValue = Math.min(this.nextAvailableValue, this.mins[i]);
            }
        }
    }

    private boolean computeCandidate(int v, DirectedGraph precedenceGraph) {
        int u = Integer.MAX_VALUE;
        this.candidate = -1;
        ISetIterator iterator = this.availableVars.iterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            if (u <= this.maxs[i] || this.containsPrecOf(this.tmp, i, precedenceGraph)) continue;
            u = this.maxs[i];
            this.candidate = i;
        }
        return u >= v && this.candidate != -1;
    }

    private boolean foundBoundSupport(int var, int val, DirectedGraph precedenceGraph, int[] topologicalTraversal) {
        if (!this.initDomains(var, val)) {
            return false;
        }
        if (!this.updateBounds(precedenceGraph, topologicalTraversal, true) || !this.updateBounds(precedenceGraph, topologicalTraversal, false)) {
            return false;
        }
        this.availableVars.clear();
        this.tmp.clear();
        ISetIterator it = this.notInstVars.iterator();
        while (it.hasNext()) {
            this.assign[it.nextInt()] = -1;
        }
        this.assign[var] = val;
        this.nextAvailableValue = this.min;
        for (int v = this.min; v <= this.max; ++v) {
            this.addAvailableValues(var, v);
            if (this.instValues.contains(v) || this.availableVars.isEmpty() || v == val) continue;
            if (!this.computeCandidate(v, precedenceGraph)) {
                return false;
            }
            this.availableVars.remove(this.candidate);
            this.tmp.remove(this.candidate);
            this.assign[this.candidate] = v;
        }
        return !PropAllDiffPrec.contains(this.assign, -1);
    }

    @Override
    public boolean propagate(DirectedGraph precedenceGraph, int[] topologicalTraversal, ICause aCause) throws ContradictionException {
        this.instValues.clear();
        this.min = Integer.MAX_VALUE;
        this.max = Integer.MIN_VALUE;
        this.instVars.clear();
        this.notInstVars.clear();
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i].isInstantiated()) {
                this.instVars.add(i);
                this.instValues.add(this.variables[i].getValue());
                this.assign[i] = this.variables[i].getValue();
                continue;
            }
            this.notInstVars.add(i);
            this.min = Math.min(this.min, this.variables[i].getLB());
            this.max = Math.max(this.max, this.variables[i].getUB());
        }
        boolean hasFiltered = false;
        for (int var = 0; var < this.variables.length; ++var) {
            if (this.rcFiltering) {
                int val = this.variables[var].getLB();
                while (val <= this.variables[var].getUB()) {
                    if (!this.foundBoundSupport(var, val, precedenceGraph, topologicalTraversal)) {
                        hasFiltered |= this.variables[var].removeValue(val, aCause);
                    }
                    val = this.variables[var].nextValue(val);
                }
            } else {
                while (!this.foundBoundSupport(var, this.variables[var].getLB(), precedenceGraph, topologicalTraversal)) {
                    hasFiltered |= this.variables[var].removeValue(this.variables[var].getLB(), aCause);
                }
                while (!this.foundBoundSupport(var, this.variables[var].getUB(), precedenceGraph, topologicalTraversal)) {
                    hasFiltered |= this.variables[var].removeValue(this.variables[var].getUB(), aCause);
                }
            }
            if (!this.variables[var].isInstantiated() || this.instVars.contains(var)) continue;
            this.instVars.add(var);
            this.notInstVars.remove(var);
            this.instValues.add(this.variables[var].getValue());
        }
        return hasFiltered;
    }
}

