## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(bignum)
library(pillar)

## -----------------------------------------------------------------------------
bigpi

## -----------------------------------------------------------------------------
options(bignum.sigfig = 10)
bigpi

## -----------------------------------------------------------------------------
options(bignum.sigfig = 3)
bigfloat(1.2345 * 10^(-1:4))

## -----------------------------------------------------------------------------
options(bignum.sigfig = 7)
bigfloat(1 + c(0, 1e-3, 1e-7))

## -----------------------------------------------------------------------------
bigfloat(1234567890123)

bigfloat(1234567890123.4)

bigfloat(12345678901234)

## -----------------------------------------------------------------------------
x <- bigfloat(1.2345 * 10^(-1:4))

format(x, notation = "dec")

format(x, notation = "sci")

## -----------------------------------------------------------------------------
format(x, sigfig = 3)

## -----------------------------------------------------------------------------
format(x, digits = 2)

format(x, digits = -2)

## -----------------------------------------------------------------------------
pillar(x)

## -----------------------------------------------------------------------------
options(pillar.sigfig = 4)
pillar(x)

## -----------------------------------------------------------------------------
options(pillar.max_dec_width = 9)
pillar(x)

