/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.rdql.EvalTypeException;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryException;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprBoolean;
import com.hp.hpl.jena.rdql.parser.ExprNode;
import com.hp.hpl.jena.rdql.parser.NodeValue;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.WorkingVar;
import java.io.PrintWriter;

public class Q_UnaryNot
extends ExprNode
implements Expr,
ExprBoolean {
    private String printName = "not";
    private String opSymbol = "!";
    Expr expr;

    Q_UnaryNot(int id) {
        super(id);
    }

    Q_UnaryNot(RDQLParser p, int id) {
        super(p, id);
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 1) {
            throw new QueryException("Q_UnaryNot: Wrong number of children: " + n);
        }
        this.expr = (Expr)((Object)this.jjtGetChild(0));
    }

    public NodeValue eval(Query q, IndexValues env) {
        NodeValue v = this.expr.eval(q, env);
        if (!v.isBoolean()) {
            throw new EvalTypeException("Q_UnaryNot: Wanted a number: got " + this.expr);
        }
        WorkingVar result = new WorkingVar();
        result.setBoolean(!v.getBoolean());
        return result;
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 1;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.expr instanceof Expression) {
            return (Expression)((Object)this.expr);
        }
        return null;
    }

    public String asInfixString() {
        return QueryPrintUtils.asInfixString1(this.expr, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryPrintUtils.asPrefixString(this.expr, null, this.printName, this.opSymbol);
    }

    public void print(PrintWriter pw, int level) {
        QueryPrintUtils.print(pw, this.expr, null, this.printName, this.opSymbol, level);
    }

    public String toString() {
        return this.asInfixString();
    }
}

