#ifndef MAXREADER_H
#define MAXREADER_H

#include "GeoCommon.h"
#include "ModelReader.h"
#include <stdlib.h>
#include <stdio.h>

/**
 * Structures and classes for reading 3D MAX ASC file format.
 *
 * @author Tao Ju
 */



/// Flags for line input
const int VERTEX_FACE_COUNT = 0 ;
const int NEW_VERTEX = 1 ;
const int NEW_FACE = 2 ;
const int NEW_OBJECT = 3 ;
const int NEW_VERTEX_LIST = 4 ;
const int NEW_FACE_LIST = 5 ;
const int REDUNDANT_INFO = -1 ;
const int END_OF_FILE = -2 ;

/* Structure for an object
 */
struct MaxObject;

/* Structure for a polygon vertex
 */
struct PolygonVertex
{
	/// Coordinates
	float cord[3];
};


/* Structure for a triangle
 */
struct TriangleArrayElement
{
	/// Coordinates
	int vert[3];

};

/* Structure for a object retrieved from a MAX file
 */
struct MaxObject
{
	/// Array of polygon vertices
	PolygonVertex* vertexArray;

	/// Array of triangles
	TriangleArrayElement* trianArray;

	/// Number of vertices/triangles
	int num_vertices, num_triangles;

};


/* Class for reading a max.asc file
 */
class MaxReader : public ModelReader
{
public:

	/// Filename
	char* fname;

	/// The input file pointer
	FILE* fin;

	/// File location
	long offset ;

	/// Number of objects
	int num_objects, cur_object;

	/// Number of triangles
	int tot_poly ;

	/// Current polygon
	int cur_poly ;

	/// Current vertex
	int cur_vert, tot_vert ;

	/// Current object
	MaxObject* object ;

	/// Min and max
	float minc[3], maxc[3], maxsize ;

	/// Constructor
	MaxReader ( char* name, float scl );

	/// Destructor
	~MaxReader ();

	/// Get next triangle
	Triangle* getNextTriangle( ) ;
	int getNextTriangle( int t[3] ) ;
	/// Get bounding box
	float getBoundingBox ( float origin[3] ) ;

	/// Get storage size
	int getMemory ( ) ;

	/// Get model size
	int getNumTriangles ( ) 
	{
		return this->tot_poly ;	
	};

	/// Vertex operations
	int getNumVertices( ) ;

	void getNextVertex( float v[3] ) ;

	/// Reset reading location
	void reset ( ) ;

	void printInfo( ) ;


private:

	/// Return number of objects in file
	int getNumberObjects ( );

	/// Return the next object in the file
	MaxObject* getNextObject( );
	
	/// Get the bounding box of all objects and return number of objects
	int getBoundingBox( float minc[3], float maxc[3] );


	/* Helper function for reading in a line in the ASC file
	 *
	 * @param ind returns the indices of triangle vertices, if the line starts with "Face: "
	 * @param cord returns the coordinates of the vertex, if the line starts with "Vertex: "
	 *
	 * @return the type of the line. Currently are:
	 *		0	Vertex & face count
	 *		1	vertex 
	 *		2	triangle
	 *		3	New object
	 *		4	Start of vertex list
	 *		5	Start of face list
	 *		-1	Redundant info
	 */

	int parseNextLine( int ind[3], float cord[3] );
};


#endif