/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.Executor;
import oracle.jdbc.driver.ConsumerExceptionEvent;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.internal.JMSConsumerExceptionListener;
import oracle.jdbc.internal.JMSNotificationListener;
import oracle.jdbc.internal.JMSNotificationRegistration;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

class NTFJMSRegistration
extends NTFRegistration
implements JMSNotificationRegistration {
    private final String name;
    private final String jmsConnectionId;
    private long jmsRegistrationId;
    private int qosFlag;

    NTFJMSRegistration(long internalId, boolean jdbcGetsNotification, String dbName, String username, @Blind(value=PropertiesBlinder.class) Properties options, String name, short dbVersionNumber, String jmsConnectionId) {
        super((int)internalId, 1, jdbcGetsNotification, dbName, null, 0, options, username, dbVersionNumber, null);
        this.name = name;
        this.jmsConnectionId = jmsConnectionId;
    }

    @Override
    public void addListener(JMSNotificationListener l, Executor e) throws SQLException {
        NTFEventListener listener = new NTFEventListener(l);
        listener.setExecutor(e);
        this.addListener(listener);
    }

    @Override
    public void addListener(JMSNotificationListener l) throws SQLException {
        NTFEventListener listener = new NTFEventListener(l);
        this.addListener(listener);
    }

    @Override
    public void setConsumerExceptionListener(JMSConsumerExceptionListener cel) throws SQLException {
        NTFEventListener lsnr = new NTFEventListener(cel);
        this.setNotificationExceptionListener(lsnr);
    }

    @Override
    public void setConsumerExceptionListener(JMSConsumerExceptionListener cel, Executor e) throws SQLException {
        NTFEventListener lsnr = new NTFEventListener(cel);
        lsnr.setExecutor(e);
        this.setNotificationExceptionListener(lsnr);
    }

    @Override
    public JMSConsumerExceptionListener getConsumerExceptionListener() throws SQLException {
        NTFEventListener lsnr = this.getNotificationExceptionListener();
        JMSConsumerExceptionListener cel = lsnr.getNtfExceptionListener();
        return cel;
    }

    void raiseException(int excpType) throws SQLException {
        String cause;
        NTFEventListener lsnr = this.getNotificationExceptionListener();
        JMSConsumerExceptionListener cel = lsnr.getNtfExceptionListener();
        if (cel == null) {
            return;
        }
        switch (excpType) {
            case 1: {
                cause = "Server Not Reachable";
                break;
            }
            case 2: {
                cause = "Consumer Closed by Administrator";
                break;
            }
            case 3: {
                cause = "Destination Queue/Topic closed by Administrator";
                break;
            }
            default: {
                return;
            }
        }
        ConsumerExceptionEvent cee = new ConsumerExceptionEvent(excpType, cause);
        cel.onConsumerException(cee);
    }

    @Override
    public void removeListener(JMSNotificationListener l) throws SQLException {
        super.removeListener(l);
    }

    @Override
    public String getQueueName() {
        return this.name;
    }

    public String getJMSConnectionId() {
        return this.jmsConnectionId;
    }

    long getJMSRegistrationId() {
        return this.jmsRegistrationId;
    }

    void setJMSRegistrationId(long _jmsRegistrationId) {
        this.jmsRegistrationId = _jmsRegistrationId;
    }

    public int getQOSFlag() {
        return this.qosFlag;
    }

    public void setQOSFlag(int qosFlag) {
        this.qosFlag = qosFlag;
    }
}

