﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>
#include <aws/iotsitewise/model/BatchGetAssetPropertyValueErrorCode.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace IoTSiteWise {
namespace Model {

/**
 * <p>Contains error information for an asset property value entry that is
 * associated with the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html">BatchGetAssetPropertyValue</a>
 * API.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueErrorEntry">AWS
 * API Reference</a></p>
 */
class BatchGetAssetPropertyValueErrorEntry {
 public:
  AWS_IOTSITEWISE_API BatchGetAssetPropertyValueErrorEntry() = default;
  AWS_IOTSITEWISE_API BatchGetAssetPropertyValueErrorEntry(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTSITEWISE_API BatchGetAssetPropertyValueErrorEntry& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_IOTSITEWISE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The error code.</p>
   */
  inline BatchGetAssetPropertyValueErrorCode GetErrorCode() const { return m_errorCode; }
  inline bool ErrorCodeHasBeenSet() const { return m_errorCodeHasBeenSet; }
  inline void SetErrorCode(BatchGetAssetPropertyValueErrorCode value) {
    m_errorCodeHasBeenSet = true;
    m_errorCode = value;
  }
  inline BatchGetAssetPropertyValueErrorEntry& WithErrorCode(BatchGetAssetPropertyValueErrorCode value) {
    SetErrorCode(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The associated error message.</p>
   */
  inline const Aws::String& GetErrorMessage() const { return m_errorMessage; }
  inline bool ErrorMessageHasBeenSet() const { return m_errorMessageHasBeenSet; }
  template <typename ErrorMessageT = Aws::String>
  void SetErrorMessage(ErrorMessageT&& value) {
    m_errorMessageHasBeenSet = true;
    m_errorMessage = std::forward<ErrorMessageT>(value);
  }
  template <typename ErrorMessageT = Aws::String>
  BatchGetAssetPropertyValueErrorEntry& WithErrorMessage(ErrorMessageT&& value) {
    SetErrorMessage(std::forward<ErrorMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the entry.</p>
   */
  inline const Aws::String& GetEntryId() const { return m_entryId; }
  inline bool EntryIdHasBeenSet() const { return m_entryIdHasBeenSet; }
  template <typename EntryIdT = Aws::String>
  void SetEntryId(EntryIdT&& value) {
    m_entryIdHasBeenSet = true;
    m_entryId = std::forward<EntryIdT>(value);
  }
  template <typename EntryIdT = Aws::String>
  BatchGetAssetPropertyValueErrorEntry& WithEntryId(EntryIdT&& value) {
    SetEntryId(std::forward<EntryIdT>(value));
    return *this;
  }
  ///@}
 private:
  BatchGetAssetPropertyValueErrorCode m_errorCode{BatchGetAssetPropertyValueErrorCode::NOT_SET};
  bool m_errorCodeHasBeenSet = false;

  Aws::String m_errorMessage;
  bool m_errorMessageHasBeenSet = false;

  Aws::String m_entryId;
  bool m_entryIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTSiteWise
}  // namespace Aws
