﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/dlm/DLMRequest.h>
#include <aws/dlm/DLM_EXPORTS.h>

#include <utility>

namespace Aws {
namespace DLM {
namespace Model {

/**
 */
class DeleteLifecyclePolicyRequest : public DLMRequest {
 public:
  AWS_DLM_API DeleteLifecyclePolicyRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteLifecyclePolicy"; }

  AWS_DLM_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The identifier of the lifecycle policy.</p>
   */
  inline const Aws::String& GetPolicyId() const { return m_policyId; }
  inline bool PolicyIdHasBeenSet() const { return m_policyIdHasBeenSet; }
  template <typename PolicyIdT = Aws::String>
  void SetPolicyId(PolicyIdT&& value) {
    m_policyIdHasBeenSet = true;
    m_policyId = std::forward<PolicyIdT>(value);
  }
  template <typename PolicyIdT = Aws::String>
  DeleteLifecyclePolicyRequest& WithPolicyId(PolicyIdT&& value) {
    SetPolicyId(std::forward<PolicyIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_policyId;
  bool m_policyIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace DLM
}  // namespace Aws
