type ArtixRepo = 'system' | 'system-gremlins' | 'system-goblins' | 'world' | 'world-gremlins' | 'world-goblins' | 'galaxy' | 'galaxy-gremlins' | 'galaxy-goblins' | 'lib32' | 'lib32-gremlins' | 'lib32-goblins';
type ArchRepo = 'core' | 'core-testing' | 'core-staging' | 'extra' | 'extra-testing' | 'extra-staging' | 'multilib' | 'multilib-testing' | 'multilib-staging';
interface CheckupdatesOptions {
    timeout?: number;
}
interface CheckupdatesResult {
    basename: string;
    artixRepo: ArtixRepo;
    artixVersion: string;
    archRepo: ArchRepo;
    archVersion: string;
    packager: string;
}
declare class Checkupdates {
    private _timeout;
    constructor(options?: CheckupdatesOptions);
    cleanUpLockfiles(): Promise<void>;
    applyCompliance(str: string): string;
    parseCheckUpdatesOutput(output: string, applyCompliance?: boolean): CheckupdatesResult[];
    checkupdates(flag: '-u' | '-m' | '-ml', applyCompliance?: boolean): Promise<CheckupdatesResult[]>;
    fetchUpgradable(applyCompliance?: boolean): Promise<CheckupdatesResult[]>;
    fetchMovable(applyCompliance?: boolean): Promise<CheckupdatesResult[]>;
    fetchLooseMovable(applyCompliance?: boolean): Promise<CheckupdatesResult[]>;
}
export default Checkupdates;
export { Checkupdates };
export type { CheckupdatesOptions, CheckupdatesResult, ArtixRepo, ArchRepo };
