"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateLanguageServiceHost = decorateLanguageServiceHost;
function decorateLanguageServiceHost(host) {
    const originalReadDirectory = host.readDirectory?.bind(host);
    host.readDirectory = originalReadDirectory
        ? (path, extensions, exclude, include, depth) => {
            const extensionsWithSvelte = extensions ? [...extensions, '.svelte'] : undefined;
            return originalReadDirectory(path, extensionsWithSvelte, exclude, include, depth);
        }
        : undefined;
}
//# sourceMappingURL=host.js.map