/*
 * Decompiled with CFR 0.152.
 */
package hughai.ui;

import hughai.PlayerObjects;
import hughai.utils.Config;
import hughai.utils.ConfigController;
import hughai.utils.Formatting;
import hughai.utils.ReflectionHelper;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConfigDialog {
    PlayerObjects playerObjects;
    JPanel configPanel;
    GridLayout configGridLayout;
    JButton configRevertButton;
    JButton configReloadButton;
    JButton configApplyButton;
    JButton configSaveButton;
    HashMap<String, JComponent> componentByName = new HashMap();

    public ConfigDialog(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.Init();
    }

    public void Init() {
        this.configGridLayout = new GridLayout(0, 2);
        this.configPanel = new JPanel(this.configGridLayout);
        this.playerObjects.getMainUI().addPanelToTabbedPanel("Config", this.configPanel);
        this.buildConfigPanel();
    }

    Method getGetMethod(Class<?> clazz, Class<?> clazz2, String string) {
        string = string.substring(0, 1).toUpperCase() + string.substring(1);
        String string2 = "get" + string;
        if (clazz2 == Boolean.TYPE || clazz2 == Boolean.class) {
            string2 = "is" + string;
        }
        Method method = null;
        try {
            method = clazz.getMethod(string2, new Class[0]);
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
        }
        return method;
    }

    Method getSetMethod(Class<?> clazz, Class<?> clazz2, String string) {
        string = string.substring(0, 1).toUpperCase() + string.substring(1);
        String string2 = "set" + string;
        Method method = null;
        try {
            method = clazz.getMethod(string2, clazz2);
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
        }
        return method;
    }

    void buildConfigPanel() {
        try {
            Config config = this.playerObjects.getConfig();
            for (Field field : config.getClass().getDeclaredFields()) {
                ReflectionHelper.Exclude exclude = field.getAnnotation(ReflectionHelper.Exclude.class);
                if (exclude != null) continue;
                Class<?> clazz = field.getType();
                Method method = this.getGetMethod(config.getClass(), field.getType(), field.getName());
                if (method != null) {
                    Object object = method.invoke((Object)config, new Object[0]);
                    if (clazz == String.class) {
                        this.addTextBox(field.getName(), (String)object);
                    }
                    if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                        this.addBooleanComponent(field.getName(), (Boolean)object);
                    }
                    if (clazz == Float.TYPE || clazz == Float.class) {
                        this.addTextBox(field.getName(), "" + object);
                    }
                    if (clazz != Integer.TYPE && clazz != Integer.class) continue;
                    this.addTextBox(field.getName(), "" + object);
                    continue;
                }
                this.playerObjects.getLogFile().WriteLine("No get accessor method for config field " + field.getName());
            }
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
        }
        this.configGridLayout.setRows(this.configGridLayout.getRows() + 2);
        this.configRevertButton = new JButton("Revert");
        this.configReloadButton = new JButton("Reload");
        this.configApplyButton = new JButton("Apply");
        this.configSaveButton = new JButton("Save");
        this.configRevertButton.addActionListener(new ConfigRevert());
        this.configReloadButton.addActionListener(new ConfigReload());
        this.configApplyButton.addActionListener(new ConfigApply());
        this.configSaveButton.addActionListener(new ConfigSave());
        this.configPanel.add(this.configRevertButton);
        this.configPanel.add(this.configReloadButton);
        this.configPanel.add(this.configApplyButton);
        this.configPanel.add(this.configSaveButton);
    }

    void addTextBox(String string, String string2) {
        this.configGridLayout.setRows(this.configGridLayout.getRows() + 1);
        this.addConfigLabel(string);
        JTextField jTextField = new JTextField();
        jTextField.setText(string2);
        this.componentByName.put(string, jTextField);
        this.configPanel.add(jTextField);
    }

    void addConfigLabel(String string) {
        JLabel jLabel = new JLabel(string);
        this.configPanel.add(jLabel);
    }

    void addBooleanComponent(String string, boolean bl) {
        this.configGridLayout.setRows(this.configGridLayout.getRows() + 1);
        this.addConfigLabel(string);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(bl);
        this.componentByName.put(string, jCheckBox);
        this.configPanel.add(jCheckBox);
    }

    void debug(Object object) {
        this.playerObjects.getLogFile().WriteLine("" + object);
    }

    void revertConfig() {
        try {
            this.debug("reverting config panel");
            Config config = this.playerObjects.getConfig();
            for (Field field : config.getClass().getDeclaredFields()) {
                ReflectionHelper.Exclude exclude = field.getAnnotation(ReflectionHelper.Exclude.class);
                if (exclude != null) continue;
                this.debug("field " + field.getName());
                Class<?> clazz = field.getType();
                Method method = this.getGetMethod(config.getClass(), field.getType(), field.getName());
                if (method != null) {
                    this.debug(" ... found accessor method");
                    Object object = method.invoke((Object)config, new Object[0]);
                    String string = field.getName();
                    Component component = this.componentByName.get(string);
                    if (component == null) continue;
                    this.debug(" ... found component");
                    if (clazz == String.class) {
                        ((JTextField)component).setText((String)object);
                    }
                    if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                        ((JCheckBox)component).setSelected((Boolean)object);
                    }
                    if (clazz == Float.TYPE || clazz == Float.class) {
                        ((JTextField)component).setText("" + object);
                    }
                    if (clazz != Integer.TYPE && clazz != Integer.class) continue;
                    ((JTextField)component).setText("" + object);
                    continue;
                }
                this.playerObjects.getLogFile().WriteLine("No get accessor method for config field " + field.getName());
            }
        }
        catch (Exception exception) {
            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
        }
    }

    void applyConfig() {
        this.debug("applying config from panel");
        Config config = this.playerObjects.getConfig();
        for (Field field : config.getClass().getDeclaredFields()) {
            ReflectionHelper.Exclude exclude = field.getAnnotation(ReflectionHelper.Exclude.class);
            if (exclude != null) continue;
            this.debug("field " + field.getName());
            Class<?> clazz = field.getType();
            Method method = this.getSetMethod(config.getClass(), field.getType(), field.getName());
            if (method != null) {
                this.debug(" ... found accessor method");
                String string = field.getName();
                Component component = this.componentByName.get(string);
                if (component != null) {
                    String string2;
                    this.debug(" ... found component");
                    Object object = null;
                    if (clazz == String.class) {
                        object = ((JTextField)component).getText();
                    }
                    if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                        object = ((JCheckBox)component).isSelected();
                    }
                    if (clazz == Float.TYPE || clazz == Float.class) {
                        string2 = ((JTextField)component).getText();
                        try {
                            object = Float.valueOf(Float.parseFloat(string2));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (clazz == Integer.TYPE || clazz == Integer.class) {
                        string2 = ((JTextField)component).getText();
                        try {
                            object = Integer.parseInt(string2);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (object != null) {
                        try {
                            method.invoke((Object)config, object);
                        }
                        catch (Exception exception) {
                            this.playerObjects.getLogFile().WriteLine(Formatting.exceptionToStackTrace(exception));
                        }
                    }
                }
                if (clazz != Boolean.TYPE && clazz != Boolean.class) continue;
            }
            this.playerObjects.getLogFile().WriteLine("No get accessor method for config field " + field.getName());
        }
        this.revertConfig();
        this.playerObjects.getMainUI().showInfo("Config updated.  Note that most changes require an AI restart.  You can click on 'reloadAI' in 'Actions' tab to do so.");
        this.playerObjects.getConfig().configUpdated();
    }

    class ConfigReload
    implements ActionListener {
        ConfigReload() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConfigDialog.this.playerObjects.getConfigController().restoreFromSource(ConfigController.ConfigSource.WorkingCopy);
            ConfigDialog.this.playerObjects.getConfig().configUpdated();
            ConfigDialog.this.revertConfig();
        }
    }

    class ConfigSave
    implements ActionListener {
        ConfigSave() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConfigDialog.this.applyConfig();
            ConfigDialog.this.playerObjects.getConfigController().writeConfigBackToSource(ConfigController.ConfigSource.XmlFile);
        }
    }

    class ConfigApply
    implements ActionListener {
        ConfigApply() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConfigDialog.this.applyConfig();
        }
    }

    class ConfigRevert
    implements ActionListener {
        ConfigRevert() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConfigDialog.this.revertConfig();
        }
    }
}

