/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Objects;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingDefinition;
import org.firebirdsql.encodings.IEncodingFactory;
import org.firebirdsql.extern.decimal.Decimal128;
import org.firebirdsql.extern.decimal.Decimal64;
import org.firebirdsql.gds.ng.DatatypeCoder;

public final class EncodingSpecificDatatypeCoder
implements DatatypeCoder {
    private final DatatypeCoder parentCoder;
    private final EncodingDefinition encodingDefinition;
    private final Encoding encoding;

    EncodingSpecificDatatypeCoder(DatatypeCoder parentCoder, EncodingDefinition encodingDefinition) {
        this.parentCoder = Objects.requireNonNull(parentCoder, "parentCoder");
        this.encodingDefinition = Objects.requireNonNull(encodingDefinition, "encodingDefinition");
        this.encoding = Objects.requireNonNull(encodingDefinition.getEncoding(), "encodingDefinition.encoding");
    }

    @Override
    public byte[] encodeString(String value) {
        return this.encoding.encodeToCharset(value);
    }

    @Override
    public Writer createWriter(OutputStream outputStream) {
        return this.encoding.createWriter(outputStream);
    }

    @Override
    public String decodeString(byte[] value) {
        return this.encoding.decodeFromCharset(value);
    }

    @Override
    public Reader createReader(InputStream inputStream) {
        return this.encoding.createReader(inputStream);
    }

    @Override
    public DatatypeCoder forEncodingDefinition(EncodingDefinition encodingDefinition) {
        if (this.encodingDefinition.equals(encodingDefinition)) {
            return this;
        }
        return this.parentCoder.forEncodingDefinition(encodingDefinition);
    }

    @Override
    public EncodingDefinition getEncodingDefinition() {
        return this.encodingDefinition;
    }

    @Override
    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public DatatypeCoder unwrap() {
        return this.parentCoder;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DatatypeCoder)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof EncodingSpecificDatatypeCoder) {
            EncodingSpecificDatatypeCoder other = (EncodingSpecificDatatypeCoder)o;
            return this.encodingDefinition.equals(other.encodingDefinition) && this.parentCoder.getClass() == other.parentCoder.getClass();
        }
        DatatypeCoder other = (DatatypeCoder)o;
        return this.encodingDefinition.equals(other.getEncodingDefinition()) && this.parentCoder.getClass() == other.getClass();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.parentCoder.getClass(), this.encodingDefinition);
    }

    @Override
    public int sizeOfShort() {
        return this.parentCoder.sizeOfShort();
    }

    @Override
    public byte[] encodeShort(short value) {
        return this.parentCoder.encodeShort(value);
    }

    @Override
    public byte[] encodeShort(int value) {
        return this.parentCoder.encodeShort(value);
    }

    @Override
    public void encodeShort(int value, byte[] target, int fromIndex) {
        this.parentCoder.encodeShort(value, target, fromIndex);
    }

    @Override
    public short decodeShort(byte[] byte_int) {
        return this.parentCoder.decodeShort(byte_int);
    }

    @Override
    public short decodeShort(byte[] bytes, int fromIndex) {
        return this.parentCoder.decodeShort(bytes, fromIndex);
    }

    @Override
    public byte[] encodeInt(int value) {
        return this.parentCoder.encodeInt(value);
    }

    @Override
    public void encodeInt(int value, byte[] target, int fromIndex) {
        this.parentCoder.encodeInt(value, target, fromIndex);
    }

    @Override
    public int decodeInt(byte[] byte_int) {
        return this.parentCoder.decodeInt(byte_int);
    }

    @Override
    public int decodeInt(byte[] bytes, int fromIndex) {
        return this.parentCoder.decodeInt(bytes, fromIndex);
    }

    @Override
    public byte[] encodeLong(long value) {
        return this.parentCoder.encodeLong(value);
    }

    @Override
    public long decodeLong(byte[] byte_int) {
        return this.parentCoder.decodeLong(byte_int);
    }

    @Override
    public byte[] encodeFloat(float value) {
        return this.parentCoder.encodeFloat(value);
    }

    @Override
    public float decodeFloat(byte[] byte_int) {
        return this.parentCoder.decodeFloat(byte_int);
    }

    @Override
    public byte[] encodeDouble(double value) {
        return this.parentCoder.encodeDouble(value);
    }

    @Override
    public double decodeDouble(byte[] byte_int) {
        return this.parentCoder.decodeDouble(byte_int);
    }

    @Override
    public Timestamp encodeTimestamp(Timestamp value, Calendar cal, boolean invertTimeZone) {
        return this.parentCoder.encodeTimestamp(value, cal, invertTimeZone);
    }

    @Override
    public byte[] encodeTimestampRaw(DatatypeCoder.RawDateTimeStruct raw) {
        return this.parentCoder.encodeTimestampRaw(raw);
    }

    @Override
    public byte[] encodeTimestampCalendar(Timestamp value, Calendar c) {
        return this.parentCoder.encodeTimestampCalendar(value, c);
    }

    @Override
    public Timestamp decodeTimestamp(Timestamp value, Calendar cal, boolean invertTimeZone) {
        return this.parentCoder.decodeTimestamp(value, cal, invertTimeZone);
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct decodeTimestampRaw(byte[] byte_long) {
        return this.parentCoder.decodeTimestampRaw(byte_long);
    }

    @Override
    public Timestamp decodeTimestampCalendar(byte[] byte_long, Calendar c) {
        return this.parentCoder.decodeTimestampCalendar(byte_long, c);
    }

    @Override
    public Time encodeTime(Time d, Calendar cal, boolean invertTimeZone) {
        return this.parentCoder.encodeTime(d, cal, invertTimeZone);
    }

    @Override
    public byte[] encodeTimeRaw(DatatypeCoder.RawDateTimeStruct raw) {
        return this.parentCoder.encodeTimeRaw(raw);
    }

    @Override
    public byte[] encodeTimeCalendar(Time d, Calendar c) {
        return this.parentCoder.encodeTimeCalendar(d, c);
    }

    @Override
    public Time decodeTime(Time d, Calendar cal, boolean invertTimeZone) {
        return this.parentCoder.decodeTime(d, cal, invertTimeZone);
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct decodeTimeRaw(byte[] int_byte) {
        return this.parentCoder.decodeTimeRaw(int_byte);
    }

    @Override
    public Time decodeTimeCalendar(byte[] int_byte, Calendar c) {
        return this.parentCoder.decodeTimeCalendar(int_byte, c);
    }

    @Override
    public Date encodeDate(Date d, Calendar cal) {
        return this.parentCoder.encodeDate(d, cal);
    }

    @Override
    public byte[] encodeDateRaw(DatatypeCoder.RawDateTimeStruct raw) {
        return this.parentCoder.encodeDateRaw(raw);
    }

    @Override
    public byte[] encodeDateCalendar(Date d, Calendar c) {
        return this.parentCoder.encodeDateCalendar(d, c);
    }

    @Override
    public Date decodeDate(Date d, Calendar cal) {
        return this.parentCoder.decodeDate(d, cal);
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct decodeDateRaw(byte[] byte_int) {
        return this.parentCoder.decodeDateRaw(byte_int);
    }

    @Override
    public Date decodeDateCalendar(byte[] byte_int, Calendar c) {
        return this.parentCoder.decodeDateCalendar(byte_int, c);
    }

    @Override
    public boolean decodeBoolean(byte[] data) {
        return this.parentCoder.decodeBoolean(data);
    }

    @Override
    public byte[] encodeBoolean(boolean value) {
        return this.parentCoder.encodeBoolean(value);
    }

    @Override
    public LocalTime decodeLocalTime(byte[] data) {
        return this.parentCoder.decodeLocalTime(data);
    }

    @Override
    public byte[] encodeLocalTime(LocalTime value) {
        return this.parentCoder.encodeLocalTime(value);
    }

    @Override
    public LocalDate decodeLocalDate(byte[] data) {
        return this.parentCoder.decodeLocalDate(data);
    }

    @Override
    public byte[] encodeLocalDate(LocalDate value) {
        return this.parentCoder.encodeLocalDate(value);
    }

    @Override
    public LocalDateTime decodeLocalDateTime(byte[] data) {
        return this.parentCoder.decodeLocalDateTime(data);
    }

    @Override
    public byte[] encodeLocalDateTime(LocalDateTime value) {
        return this.parentCoder.encodeLocalDateTime(value);
    }

    @Override
    public Decimal64 decodeDecimal64(byte[] data) {
        return this.parentCoder.decodeDecimal64(data);
    }

    @Override
    public byte[] encodeDecimal64(Decimal64 decimal64) {
        return this.parentCoder.encodeDecimal64(decimal64);
    }

    @Override
    public Decimal128 decodeDecimal128(byte[] data) {
        return this.parentCoder.decodeDecimal128(data);
    }

    @Override
    public byte[] encodeDecimal128(Decimal128 decimal128) {
        return this.parentCoder.encodeDecimal128(decimal128);
    }

    @Override
    public BigInteger decodeInt128(byte[] data) {
        return this.parentCoder.decodeInt128(data);
    }

    @Override
    public byte[] encodeInt128(BigInteger bigInteger) {
        return this.parentCoder.encodeInt128(bigInteger);
    }

    @Override
    public IEncodingFactory getEncodingFactory() {
        return this.parentCoder.getEncodingFactory();
    }
}

