/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.keywords.MappingToKeywordsNode;
import com.oracle.graal.python.nodes.argument.keywords.NonMappingException;
import com.oracle.graal.python.nodes.argument.keywords.SameDictKeyException;
import com.oracle.graal.python.nodes.bytecode.AbstractKwargsNode;
import com.oracle.graal.python.nodes.bytecode.KeywordsNodeGen;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateUncached
@GenerateInline(value=false)
public abstract class KeywordsNode
extends AbstractKwargsNode {
    public abstract PKeyword[] execute(Frame var1, Object var2, int var3);

    @Specialization
    static PKeyword[] kwords(VirtualFrame frame, Object sourceCollection, int stackTop, @Bind Node inliningTarget, @Cached MappingToKeywordsNode expandKeywordStarargsNode, @Cached InlinedBranchProfile keywordsError1, @Cached InlinedBranchProfile keywordsError2, @Cached PRaiseNode raise) {
        try {
            return expandKeywordStarargsNode.execute(frame, inliningTarget, sourceCollection);
        }
        catch (SameDictKeyException e) {
            keywordsError1.enter(inliningTarget);
            throw KeywordsNode.handleSameKey(frame, inliningTarget, raise, stackTop, e);
        }
        catch (NonMappingException e) {
            keywordsError2.enter(inliningTarget);
            throw KeywordsNode.handleNonMapping(frame, inliningTarget, raise, stackTop, e);
        }
    }

    public static KeywordsNode create() {
        return KeywordsNodeGen.create();
    }

    public static KeywordsNode getUncached() {
        return KeywordsNodeGen.getUncached();
    }
}

