/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.object.ObjectNodes;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRepr;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNodeGen;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateCached
@GenerateInline(inlineByDefault=true)
public abstract class PyObjectReprAsObjectNode
extends PNodeWithContext {
    public static Object executeUncached(Object object) {
        return PyObjectReprAsObjectNodeGen.getUncached().execute(null, null, object);
    }

    public static PyObjectReprAsObjectNode getUncached() {
        return PyObjectReprAsObjectNodeGen.getUncached();
    }

    public final Object executeCached(Frame frame, Object object) {
        return this.execute(frame, this, object);
    }

    public abstract Object execute(Frame var1, Node var2, Object var3);

    @Specialization
    static Object repr(VirtualFrame frame, Node inliningTarget, Object obj, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotRepr.CallSlotReprNode callSlot, @Cached(inline=false) ObjectNodes.DefaultObjectReprNode defaultRepr, @Cached PyUnicodeCheckNode checkNode, @Cached PRaiseNode raiseNode) {
        TpSlots slots = getSlots.execute(inliningTarget, obj);
        if (slots.tp_repr() == null) {
            return defaultRepr.execute((Frame)frame, inliningTarget, obj);
        }
        Object result = callSlot.execute(frame, inliningTarget, slots.tp_repr(), obj);
        TruffleStringMigrationHelpers.assertNoJavaString(result);
        if (checkNode.execute(inliningTarget, result)) {
            return result;
        }
        throw PyObjectReprAsObjectNode.raiseTypeError(inliningTarget, obj, raiseNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseTypeError(Node inliningTarget, Object obj, PRaiseNode raiseNode) {
        throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.RETURNED_NON_STRING, SpecialMethodNames.T___REPR__, obj);
    }

    @NeverDefault
    public static PyObjectReprAsObjectNode create() {
        return PyObjectReprAsObjectNodeGen.create();
    }
}

