/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.JakartaExceptionFactory;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringNumberImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public final class JakartaPrimitive {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    private static boolean stringsEqual(JsonString ths, Object other) {
        if (!(other instanceof JsonString)) {
            return false;
        }
        return ths == other || ths.getString().equals(((JsonString)other).getString());
    }

    private JakartaPrimitive() {
    }

    static {
        try {
            $$$methodRef$$$2 = JakartaPrimitive.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = JakartaPrimitive.class.getDeclaredMethod("access$100", JsonString.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = JakartaPrimitive.class.getDeclaredMethod("stringsEqual", JsonString.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    private static interface DefaultJsonString
    extends JsonString,
    Wrapper {
        default public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.STRING;
        }

        public OracleJsonValue getUnwrapped();

        @Override
        default public <T> T unwrap(Class<T> wrapped) throws SQLException {
            OracleJsonValue unwrapped = this.getUnwrapped();
            if (wrapped.isInstance(unwrapped)) {
                return (T)unwrapped;
            }
            throw new SQLException(OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, wrapped.getName()).getMessage());
        }

        @Override
        default public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return iface.isInstance(this.getUnwrapped());
        }

        default public CharSequence getChars() {
            return this.getString();
        }
    }

    private static abstract class DefaultJsonNumber
    extends OracleJsonNumberImpl
    implements JsonNumber,
    Wrapper {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        private DefaultJsonNumber() {
        }

        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.NUMBER;
        }

        abstract OracleJsonValue getUnwrapped();

        @Override
        public <T> T unwrap(Class<T> wrapped) throws SQLException {
            OracleJsonValue unwrapped = this.getUnwrapped();
            if (wrapped.isInstance(unwrapped)) {
                return (T)unwrapped;
            }
            throw new SQLException(OracleJsonExceptions.BAD_WRAP.create(OracleJsonExceptions.ORACLE_FACTORY, wrapped.getName()).getMessage());
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return iface.isInstance(this.getUnwrapped());
        }

        @Override
        public String getString() {
            try {
                return ((OracleJsonNumberImpl)((Object)this.unwrap(OracleJsonNumber.class))).getString();
            }
            catch (SQLException e2) {
                throw new IllegalStateException();
            }
        }

        public final boolean equals(Object other) {
            if (!(other instanceof JsonNumber)) {
                return false;
            }
            return this.bigDecimalValue().equals(((JsonNumber)other).bigDecimalValue());
        }

        public final int hashCode() {
            return this.bigDecimalValue().hashCode();
        }

        static {
            try {
                $$$methodRef$$$7 = DefaultJsonNumber.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = DefaultJsonNumber.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = DefaultJsonNumber.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = DefaultJsonNumber.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = DefaultJsonNumber.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = DefaultJsonNumber.class.getDeclaredMethod("isWrapperFor", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = DefaultJsonNumber.class.getDeclaredMethod("unwrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = DefaultJsonNumber.class.getDeclaredMethod("getValueType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaStringNumberImpl
    extends DefaultJsonNumber {
        private String value;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        public JakartaStringNumberImpl(String value) {
            this.value = value;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return new BigDecimal(this.value);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonStringNumberImpl(this.value);
        }

        static {
            try {
                $$$methodRef$$$6 = JakartaStringNumberImpl.class.getDeclaredConstructor(String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = JakartaStringNumberImpl.class.getDeclaredMethod("getValueType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaStringNumberImpl.class.getDeclaredMethod("unwrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaStringNumberImpl.class.getDeclaredMethod("isWrapperFor", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaStringNumberImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaStringNumberImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaStringNumberImpl.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaIntervalYMImpl
    implements DefaultJsonString {
        byte[] raw;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JakartaIntervalYMImpl(byte[] raw) {
            this.raw = raw;
        }

        public boolean equals(Object other) {
            return JakartaPrimitive.stringsEqual(this, other);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.serializeIntervalYM(JakartaExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonIntervalYMImpl(this.raw);
        }

        static {
            try {
                $$$methodRef$$$5 = JakartaIntervalYMImpl.class.getDeclaredConstructor(byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaIntervalYMImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaIntervalYMImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaIntervalYMImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaIntervalYMImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaIntervalYMImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaIntervalDSImpl
    implements DefaultJsonString {
        private byte[] raw;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JakartaIntervalDSImpl(byte[] raw) {
            this.raw = raw;
        }

        public boolean equals(Object other) {
            return JakartaPrimitive.stringsEqual(this, other);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.serializeIntervalDS(JakartaExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonIntervalDSImpl(this.raw);
        }

        static {
            try {
                $$$methodRef$$$5 = JakartaIntervalDSImpl.class.getDeclaredConstructor(byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaIntervalDSImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaIntervalDSImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaIntervalDSImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaIntervalDSImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaIntervalDSImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaTimestampTZImpl
    implements DefaultJsonString {
        private byte[] raw;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JakartaTimestampTZImpl(byte[] raw) {
            this.raw = raw;
        }

        public boolean equals(Object other) {
            return JakartaPrimitive.stringsEqual(this, other);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.timestampTZToString(JakartaExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonTimestampTZImpl(this.raw);
        }

        static {
            try {
                $$$methodRef$$$5 = JakartaTimestampTZImpl.class.getDeclaredConstructor(byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaTimestampTZImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaTimestampTZImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaTimestampTZImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaTimestampTZImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaTimestampTZImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaTimestampImpl
    implements DefaultJsonString {
        private byte[] raw;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JakartaTimestampImpl(byte[] raw) {
            this.raw = raw;
        }

        public boolean equals(Object other) {
            return JakartaPrimitive.stringsEqual(this, other);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.timestampToString(JakartaExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonTimestampImpl(this.raw);
        }

        static {
            try {
                $$$methodRef$$$5 = JakartaTimestampImpl.class.getDeclaredConstructor(byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaTimestampImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaTimestampImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaTimestampImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaTimestampImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaTimestampImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaDateImpl
    implements DefaultJsonString {
        byte[] raw;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JakartaDateImpl(byte[] raw) {
            this.raw = raw;
        }

        public boolean equals(Object other) {
            return JakartaPrimitive.stringsEqual(this, other);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OsonPrimitiveConversions.dateToString(JakartaExceptionFactory.INSTANCE, this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonDateImpl(this.raw);
        }

        static {
            try {
                $$$methodRef$$$5 = JakartaDateImpl.class.getDeclaredConstructor(byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaDateImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaDateImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaDateImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaDateImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaDateImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaBinaryImpl
    implements DefaultJsonString {
        byte[] bytes;
        boolean isId;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JakartaBinaryImpl(byte[] bytes, boolean isId) {
            this.bytes = bytes;
            this.isId = isId;
        }

        public boolean equals(Object other) {
            return JakartaPrimitive.stringsEqual(this, other);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        public String getString() {
            return OracleJsonBinaryImpl.getString(this.bytes, this.isId);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonBinaryImpl(this.bytes, this.isId);
        }

        static {
            try {
                $$$methodRef$$$5 = JakartaBinaryImpl.class.getDeclaredConstructor(byte[].class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaBinaryImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaBinaryImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaBinaryImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaBinaryImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaBinaryImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaStringImpl
    implements DefaultJsonString {
        String value;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        public JakartaStringImpl(String value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            return JakartaPrimitive.stringsEqual(this, other);
        }

        public int hashCode() {
            return this.getString().hashCode();
        }

        public String getString() {
            return this.value;
        }

        public String toString() {
            return JsonSerializerImpl.serializeString(this.getString());
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonStringImpl(this.value);
        }

        static {
            try {
                $$$methodRef$$$5 = JakartaStringImpl.class.getDeclaredConstructor(String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaStringImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaStringImpl.class.getDeclaredMethod("toString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaStringImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaStringImpl.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaStringImpl.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaDoubleImpl
    extends DefaultJsonNumber {
        double value;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        public JakartaDoubleImpl(double value) {
            this.value = value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return BigDecimal.valueOf(this.value);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonDoubleImpl(this.value);
        }

        static {
            try {
                $$$methodRef$$$7 = JakartaDoubleImpl.class.getDeclaredConstructor(Double.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = JakartaDoubleImpl.class.getDeclaredMethod("getValueType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = JakartaDoubleImpl.class.getDeclaredMethod("unwrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaDoubleImpl.class.getDeclaredMethod("isWrapperFor", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaDoubleImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaDoubleImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaDoubleImpl.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaDoubleImpl.class.getDeclaredMethod("doubleValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaFloatImpl
    extends DefaultJsonNumber {
        private float value;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        public JakartaFloatImpl(float value) {
            this.value = value;
        }

        @Override
        public BigDecimal bigDecimalValue() {
            return BigDecimal.valueOf(this.value);
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonFloatImpl(this.value);
        }

        static {
            try {
                $$$methodRef$$$7 = JakartaFloatImpl.class.getDeclaredConstructor(Float.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = JakartaFloatImpl.class.getDeclaredMethod("getValueType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = JakartaFloatImpl.class.getDeclaredMethod("unwrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaFloatImpl.class.getDeclaredMethod("isWrapperFor", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaFloatImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaFloatImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaFloatImpl.class.getDeclaredMethod("floatValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaFloatImpl.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    public static class JakartaNumberImpl
    extends DefaultJsonNumber {
        byte[] raw;
        OracleJsonDecimal.TargetType type;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;

        public JakartaNumberImpl(byte[] raw, OracleJsonDecimal.TargetType type) {
            this.raw = raw;
            this.type = type;
        }

        @Override
        public final BigDecimal bigDecimalValue() {
            return OsonPrimitiveConversions.toBigDecimal(this.raw);
        }

        @Override
        public OracleJsonValue getUnwrapped() {
            return new OracleJsonDecimalImpl(this.raw, this.type);
        }

        static {
            try {
                $$$methodRef$$$6 = JakartaNumberImpl.class.getDeclaredConstructor(byte[].class, OracleJsonDecimal.TargetType.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = JakartaNumberImpl.class.getDeclaredMethod("getValueType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = JakartaNumberImpl.class.getDeclaredMethod("unwrap", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = JakartaNumberImpl.class.getDeclaredMethod("isWrapperFor", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = JakartaNumberImpl.class.getDeclaredMethod("getString", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = JakartaNumberImpl.class.getDeclaredMethod("getUnwrapped", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = JakartaNumberImpl.class.getDeclaredMethod("bigDecimalValue", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

