/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.lib.CallBinaryIOp1Node;
import com.oracle.graal.python.lib.PySequenceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@GenerateInline
@GenerateCached(value=false)
public abstract class PySequenceInPlaceConcatNode
extends PNodeWithContext {
    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4);

    @Specialization
    static Object doIt(VirtualFrame frame, Node inliningTarget, Object v, Object w, @Cached GetClassNode getVClass, @Cached TpSlots.GetCachedTpSlotsNode getVSlots, @Cached TpSlots.GetCachedTpSlotsNode getWSlots, @Cached GetClassNode getWClass, @Cached PySequenceCheckNode pySeqCheckV, @Cached PySequenceCheckNode pySeqCheckW, @Cached CallBinaryIOp1Node callBinaryIOp1Node, @Cached InlinedBranchProfile hasInplaceConcat, @Cached InlinedBranchProfile hasConcat, @Cached InlinedBranchProfile hasNbAddSlot, @Cached InlinedBranchProfile hasNbAddResult, @Cached TpSlotBinaryFunc.CallSlotBinaryFuncNode callBinarySlotNode, @Cached PRaiseNode raiseNode) {
        Object classV = getVClass.execute(inliningTarget, v);
        TpSlots slotsV = getVSlots.execute(inliningTarget, classV);
        TpSlot concatSlot = null;
        if (slotsV.sq_inplace_concat() != null) {
            hasInplaceConcat.enter(inliningTarget);
            concatSlot = slotsV.sq_inplace_concat();
        } else if (slotsV.sq_concat() != null) {
            hasConcat.enter(inliningTarget);
            concatSlot = slotsV.sq_concat();
        }
        if (concatSlot != null) {
            return callBinarySlotNode.execute(frame, inliningTarget, concatSlot, v, w);
        }
        if (pySeqCheckV.execute(inliningTarget, v) && pySeqCheckW.execute(inliningTarget, w)) {
            Object classW = getWClass.execute(inliningTarget, w);
            TpSlots slotsW = getWSlots.execute(inliningTarget, classW);
            hasNbAddSlot.enter(inliningTarget);
            Object result = callBinaryIOp1Node.execute(frame, inliningTarget, v, classV, slotsV, w, classW, slotsW, TpSlotBinaryOp.InplaceSlot.NB_INPLACE_ADD);
            if (result != PNotImplemented.NOT_IMPLEMENTED) {
                hasNbAddResult.enter(inliningTarget);
                return result;
            }
        }
        return PySequenceInPlaceConcatNode.raiseNotSupported(inliningTarget, v, raiseNode);
    }

    @HostCompilerDirectives.InliningCutoff
    private static PException raiseNotSupported(Node inliningTarget, Object v, PRaiseNode raiseNode) {
        return raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_CANT_BE_CONCATENATED, v);
    }
}

