/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestActions;
import org.opensearch.security.action.configupdate.ConfigUpdateAction;
import org.opensearch.security.action.configupdate.ConfigUpdateRequest;
import org.opensearch.security.configuration.AdminDNs;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.filter.SecurityRequestFactory;
import org.opensearch.security.ssl.transport.PrincipalExtractor;
import org.opensearch.security.ssl.util.SSLRequestHelper;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.node.NodeClient;

public class SecurityConfigUpdateAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, "/configupdate")), "/_plugins/_security");
    private static final List<RestHandler.DeprecatedRoute> deprecatedRoutes = Utils.addDeprecatedRoutesPrefix((List<RestHandler.DeprecatedRoute>)ImmutableList.of((Object)new RestHandler.DeprecatedRoute(RestRequest.Method.PUT, "/configupdate", "[_opendistro/_security] is a deprecated endpoint path. Please use _plugins/_security instead.")), "/_opendistro/_security");
    private final ThreadContext threadContext;
    private final AdminDNs adminDns;
    private final Settings settings;
    private final Path configPath;
    private final PrincipalExtractor principalExtractor;

    public SecurityConfigUpdateAction(Settings settings, RestController controller, ThreadPool threadPool, AdminDNs adminDns, Path configPath, PrincipalExtractor principalExtractor) {
        this.threadContext = threadPool.getThreadContext();
        this.adminDns = adminDns;
        this.settings = settings;
        this.configPath = configPath;
        this.principalExtractor = principalExtractor;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return deprecatedRoutes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] configTypes = request.paramAsStringArrayOrEmptyIfAll("config_types");
        SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo(this.settings, this.configPath, SecurityRequestFactory.from(request), this.principalExtractor);
        if (sslInfo == null) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, ""));
        }
        User user = (User)this.threadContext.getTransient("_opendistro_security_user");
        if (user == null || !this.adminDns.isAdmin(user)) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.FORBIDDEN, ""));
        }
        ConfigUpdateRequest configUpdateRequest = new ConfigUpdateRequest(configTypes);
        return channel -> client.execute((ActionType)ConfigUpdateAction.INSTANCE, (ActionRequest)configUpdateRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    public String getName() {
        return "Security config update";
    }
}

