/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.tracker;

import ai.djl.training.tracker.ParameterTracker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FixedPerVarTracker
implements ParameterTracker {
    private float value;
    private Map<String, Float> valueMap;

    public FixedPerVarTracker(Builder builder) {
        this.value = builder.value;
        this.valueMap = builder.valueMap;
    }

    @Override
    public float getNewValue(String parameterId, int numUpdate) {
        return this.valueMap.getOrDefault(parameterId, Float.valueOf(this.value)).floatValue();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private float value;
        private Map<String, Float> valueMap = new ConcurrentHashMap<String, Float>();

        private Builder() {
        }

        public Builder setDefaultValue(float value) {
            this.value = value;
            return this;
        }

        public Builder put(String parameterId, float value) {
            this.valueMap.put(parameterId, Float.valueOf(value));
            return this;
        }

        public Builder putAll(Map<String, Float> valueMap) {
            this.valueMap.putAll(valueMap);
            return this;
        }

        public FixedPerVarTracker build() {
            return new FixedPerVarTracker(this);
        }
    }
}

