/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.action;

import java.util.Collections;
import java.util.List;
import org.opensearch.OpenSearchException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.geospatial.annotation.VisibleForTesting;
import org.opensearch.geospatial.ip2geo.action.GetDatasourceRequest;
import org.opensearch.geospatial.ip2geo.action.GetDatasourceResponse;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.ip2geo.jobscheduler.Datasource;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetDatasourceTransportAction
extends HandledTransportAction<GetDatasourceRequest, GetDatasourceResponse> {
    private final DatasourceDao datasourceDao;

    @Inject
    public GetDatasourceTransportAction(TransportService transportService, ActionFilters actionFilters, DatasourceDao datasourceDao) {
        super("cluster:admin/geospatial/datasource/get", transportService, actionFilters, GetDatasourceRequest::new);
        this.datasourceDao = datasourceDao;
    }

    protected void doExecute(Task task, GetDatasourceRequest request, ActionListener<GetDatasourceResponse> listener) {
        if (this.shouldGetAllDatasource(request)) {
            this.datasourceDao.getAllDatasources(this.newActionListener(listener));
        } else {
            this.datasourceDao.getDatasources(request.getNames(), this.newActionListener(listener));
        }
    }

    private boolean shouldGetAllDatasource(GetDatasourceRequest request) {
        if (request.getNames() == null) {
            throw new OpenSearchException("names in a request should not be null", new Object[0]);
        }
        return request.getNames().length == 0 || request.getNames().length == 1 && "_all".equals(request.getNames()[0]);
    }

    @VisibleForTesting
    protected ActionListener<List<Datasource>> newActionListener(final ActionListener<GetDatasourceResponse> listener) {
        return new ActionListener<List<Datasource>>(this){

            public void onResponse(List<Datasource> datasources) {
                listener.onResponse((Object)new GetDatasourceResponse(datasources));
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    listener.onResponse((Object)new GetDatasourceResponse(Collections.emptyList()));
                    return;
                }
                listener.onFailure(e);
            }
        };
    }
}

