function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) { n[e] = r[e]; } return n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import AceEditor from 'react-ace';
import { keysOf } from '../common';
import { htmlIdGenerator, keys } from '../../services';
import { OuiI18n } from '../i18n';
var DEFAULT_MODE = 'text';
var DEFAULT_THEME = 'textmate';
function setOrRemoveAttribute(element, attributeName, value) {
  if (value === null || value === undefined) {
    element.removeAttribute(attributeName);
  } else {
    element.setAttribute(attributeName, value);
  }
}
export var OuiCodeEditor = /*#__PURE__*/function (_Component) {
  _inherits(OuiCodeEditor, _Component);
  var _super = _createSuper(OuiCodeEditor);
  function OuiCodeEditor() {
    var _this;
    _classCallCheck(this, OuiCodeEditor);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "state", {
      isHintActive: true,
      isEditing: false,
      name: htmlIdGenerator()()
    });
    _defineProperty(_assertThisInitialized(_this), "idGenerator", htmlIdGenerator());
    _defineProperty(_assertThisInitialized(_this), "aceEditor", null);
    _defineProperty(_assertThisInitialized(_this), "editorHint", null);
    _defineProperty(_assertThisInitialized(_this), "aceEditorRef", function (aceEditor) {
      if (aceEditor) {
        _this.aceEditor = aceEditor;
        var textbox = aceEditor.editor.textInput.getElement();
        textbox.tabIndex = -1;
        textbox.addEventListener('keydown', _this.onKeydownAce);
        setOrRemoveAttribute(textbox, 'aria-label', _this.props['aria-label']);
        setOrRemoveAttribute(textbox, 'aria-labelledby', _this.props['aria-labelledby']);
        setOrRemoveAttribute(textbox, 'aria-describedby', _this.props['aria-describedby']);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onEscToExit", function () {
      _this.stopEditing();
      if (_this.editorHint) {
        _this.editorHint.focus();
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onKeydownAce", function (event) {
      if (event.key === keys.ESCAPE) {
        event.preventDefault();
        event.stopPropagation();
        // Handles exiting edit mode when `isReadOnly` is set.
        // Other 'esc' cases handled by `stopEditingOnEsc` command.
        // Would run after `stopEditingOnEsc`.
        if (_this.aceEditor !== null && !_this.aceEditor.editor.completer && _this.state.isEditing) {
          _this.onEscToExit();
        }
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onFocusAce", function (event, editor) {
      _this.setState({
        isEditing: true
      });
      if (_this.props.onFocus) {
        _this.props.onFocus(event, editor);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onBlurAce", function (event, editor) {
      _this.stopEditing();
      if (_this.props.onBlur) {
        _this.props.onBlur(event, editor);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "startEditing", function () {
      _this.setState({
        isHintActive: false
      });
      if (_this.aceEditor !== null) {
        _this.aceEditor.editor.textInput.focus();
      }
    });
    return _this;
  }
  _createClass(OuiCodeEditor, [{
    key: "stopEditing",
    value: function stopEditing() {
      this.setState({
        isHintActive: true,
        isEditing: false
      });
    }
  }, {
    key: "isCustomMode",
    value: function isCustomMode() {
      return _typeof(this.props.mode) === 'object';
    }
  }, {
    key: "setCustomMode",
    value: function setCustomMode() {
      if (this.aceEditor !== null) {
        this.aceEditor.editor.getSession().setMode(this.props.mode);
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.isCustomMode()) {
        this.setCustomMode();
      }
      var _this$props = this.props,
        isReadOnly = _this$props.isReadOnly,
        id = _this$props.id;
      var textareaProps = {
        id: id,
        readOnly: isReadOnly
      };
      var el = document.getElementById(this.state.name);
      if (el) {
        var textarea = el.querySelector('textarea');
        if (textarea) keysOf(textareaProps).forEach(function (key) {
          if (textareaProps[key]) textarea.setAttribute("".concat(key), textareaProps[key].toString());
        });
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.mode !== prevProps.mode && this.isCustomMode()) {
        this.setCustomMode();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props2 = this.props,
        width = _this$props2.width,
        height = _this$props2.height,
        onBlur = _this$props2.onBlur,
        isReadOnly = _this$props2.isReadOnly,
        setOptions = _this$props2.setOptions,
        cursorStart = _this$props2.cursorStart,
        _this$props2$mode = _this$props2.mode,
        mode = _this$props2$mode === void 0 ? DEFAULT_MODE : _this$props2$mode,
        _this$props2$dataTes = _this$props2['data-test-subj'],
        dataTestSubj = _this$props2$dataTes === void 0 ? 'codeEditorContainer' : _this$props2$dataTes,
        _this$props2$theme = _this$props2.theme,
        theme = _this$props2$theme === void 0 ? DEFAULT_THEME : _this$props2$theme,
        _this$props2$commands = _this$props2.commands,
        commands = _this$props2$commands === void 0 ? [] : _this$props2$commands,
        rest = _objectWithoutProperties(_this$props2, ["width", "height", "onBlur", "isReadOnly", "setOptions", "cursorStart", "mode", "data-test-subj", "theme", "commands"]);
      var classes = classNames('ouiCodeEditorWrapper', {
        'ouiCodeEditorWrapper-isEditing': this.state.isEditing
      });
      var promptClasses = classNames('ouiCodeEditorKeyboardHint', {
        'ouiCodeEditorKeyboardHint-isInactive': !this.state.isHintActive
      });
      var filteredCursorStart;
      var options = _objectSpread({}, setOptions);
      if (isReadOnly) {
        // Put the cursor at the beginning of the editor, so that it doesn't look like
        // a prompt to begin typing.
        filteredCursorStart = -1;
        Object.assign(options, {
          readOnly: true,
          highlightActiveLine: false,
          highlightGutterLine: false
        });
      } else {
        filteredCursorStart = cursorStart;
      }
      var prompt = /*#__PURE__*/React.createElement("button", {
        className: promptClasses,
        id: this.idGenerator('codeEditor'),
        ref: function ref(hint) {
          _this2.editorHint = hint;
        },
        onClick: this.startEditing,
        "data-test-subj": "codeEditorHint"
      }, /*#__PURE__*/React.createElement("p", {
        className: "ouiText"
      }, isReadOnly ? /*#__PURE__*/React.createElement(OuiI18n, {
        token: "ouiCodeEditor.startInteracting",
        default: "Press Enter to start interacting with the code."
      }) : /*#__PURE__*/React.createElement(OuiI18n, {
        token: "ouiCodeEditor.startEditing",
        default: "Press Enter to start editing."
      })), /*#__PURE__*/React.createElement("p", {
        className: "ouiText"
      }, isReadOnly ? /*#__PURE__*/React.createElement(OuiI18n, {
        token: "ouiCodeEditor.stopInteracting",
        default: "When you're done, press Escape to stop interacting with the code."
      }) : /*#__PURE__*/React.createElement(OuiI18n, {
        token: "ouiCodeEditor.stopEditing",
        default: "When you're done, press Escape to stop editing."
      })));
      return /*#__PURE__*/React.createElement("div", {
        className: classes,
        style: {
          width: width,
          height: height
        },
        "data-test-subj": dataTestSubj
      }, prompt, /*#__PURE__*/React.createElement(AceEditor
      // Setting a default, existing `mode` is necessary to properly initialize the editor
      // prior to dynamically setting a custom mode (https://github.com/elastic/eui/pull/2616)
      , _extends({
        mode: this.isCustomMode() ? DEFAULT_MODE : mode // https://github.com/securingsincity/react-ace/pull/771
        ,
        name: this.state.name,
        theme: theme,
        ref: this.aceEditorRef,
        width: width,
        height: height,
        onFocus: this.onFocusAce,
        onBlur: this.onBlurAce,
        setOptions: options,
        editorProps: {
          $blockScrolling: Infinity
        },
        cursorStart: filteredCursorStart,
        commands: [
        // Handles exiting edit mode in all cases except `isReadOnly`
        // Runs before `onKeydownAce`.
        {
          name: 'stopEditingOnEsc',
          bindKey: {
            win: 'Esc',
            mac: 'Esc'
          },
          exec: this.onEscToExit
        }].concat(_toConsumableArray(commands))
      }, rest)));
    }
  }]);
  return OuiCodeEditor;
}(Component);

/* OUI -> EUI Aliases: Build-Time */
_defineProperty(OuiCodeEditor, "defaultProps", {
  setOptions: {}
});
OuiCodeEditor.propTypes = {
  width: PropTypes.string,
  height: PropTypes.string,
  onBlur: PropTypes.any,
  onFocus: PropTypes.any,
  isReadOnly: PropTypes.bool,
  setOptions: PropTypes.any.isRequired,
  cursorStart: PropTypes.number,
  "data-test-subj": PropTypes.string,
  /**
     * Select the `brace` theme
     * The matching theme file must also be imported from `brace` (e.g., `import 'brace/theme/github';`)
     */
  theme: PropTypes.any,
  /**
     * Use string for a built-in mode or object for a custom mode
     */
  mode: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired]),
  id: PropTypes.string
};
/* OUI -> EUI Aliases: Build-Time */export { EuiCodeEditor } from '../../eui_components/code_editor/code_editor';