/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.tuple;

import com.yahoo.memory.Memory;
import com.yahoo.memory.WritableMemory;
import com.yahoo.sketches.Family;
import com.yahoo.sketches.SketchesArgumentException;
import com.yahoo.sketches.tuple.ArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.ArrayOfDoublesQuickSelectSketch;
import com.yahoo.sketches.tuple.ArrayOfDoublesSketch;
import com.yahoo.sketches.tuple.ArrayOfDoublesSketchIterator;
import com.yahoo.sketches.tuple.DirectArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.DirectArrayOfDoublesQuickSelectSketch;
import com.yahoo.sketches.tuple.DirectArrayOfDoublesQuickSelectSketchR;
import com.yahoo.sketches.tuple.DirectArrayOfDoublesUnion;
import com.yahoo.sketches.tuple.DirectArrayOfDoublesUnionR;
import com.yahoo.sketches.tuple.HeapArrayOfDoublesCompactSketch;
import com.yahoo.sketches.tuple.HeapArrayOfDoublesUnion;
import com.yahoo.sketches.tuple.SerializerDeserializer;
import com.yahoo.sketches.tuple.Util;

public abstract class ArrayOfDoublesUnion {
    static final byte serialVersionUID = 1;
    static final int PREAMBLE_SIZE_BYTES = 16;
    static final int PREAMBLE_LONGS_BYTE = 0;
    static final int SERIAL_VERSION_BYTE = 1;
    static final int FAMILY_ID_BYTE = 2;
    static final int SKETCH_TYPE_BYTE = 3;
    static final int FLAGS_BYTE = 4;
    static final int NUM_VALUES_BYTE = 5;
    static final int SEED_HASH_SHORT = 6;
    static final int THETA_LONG = 8;
    final int nomEntries_;
    final int numValues_;
    final long seed_;
    final short seedHash_;
    ArrayOfDoublesQuickSelectSketch sketch_;
    long theta_;

    ArrayOfDoublesUnion(ArrayOfDoublesQuickSelectSketch sketch) {
        this.nomEntries_ = sketch.getNominalEntries();
        this.numValues_ = sketch.getNumValues();
        this.seed_ = sketch.getSeed();
        this.seedHash_ = Util.computeSeedHash(this.seed_);
        this.sketch_ = sketch;
        this.theta_ = sketch.getThetaLong();
    }

    public static ArrayOfDoublesUnion heapify(Memory mem) {
        return ArrayOfDoublesUnion.heapify(mem, 9001L);
    }

    public static ArrayOfDoublesUnion heapify(Memory mem, long seed) {
        return HeapArrayOfDoublesUnion.heapifyUnion(mem, seed);
    }

    public static ArrayOfDoublesUnion wrap(Memory mem) {
        return ArrayOfDoublesUnion.wrap(mem, 9001L);
    }

    public static ArrayOfDoublesUnion wrap(Memory mem, long seed) {
        return ArrayOfDoublesUnion.wrapUnionImpl((WritableMemory)mem, seed, false);
    }

    public static ArrayOfDoublesUnion wrap(WritableMemory mem) {
        return ArrayOfDoublesUnion.wrap(mem, 9001L);
    }

    public static ArrayOfDoublesUnion wrap(WritableMemory mem, long seed) {
        return ArrayOfDoublesUnion.wrapUnionImpl(mem, seed, true);
    }

    public void update(ArrayOfDoublesSketch sketchIn) {
        if (sketchIn == null) {
            return;
        }
        Util.checkSeedHashes(this.seedHash_, sketchIn.getSeedHash());
        if (this.sketch_.getNumValues() != sketchIn.getNumValues()) {
            throw new SketchesArgumentException("Incompatible sketches: number of values mismatch " + this.sketch_.getNumValues() + " and " + sketchIn.getNumValues());
        }
        if (sketchIn.isEmpty()) {
            return;
        }
        if (sketchIn.getThetaLong() < this.theta_) {
            this.theta_ = sketchIn.getThetaLong();
        }
        ArrayOfDoublesSketchIterator it = sketchIn.iterator();
        while (it.next()) {
            this.sketch_.merge(it.getKey(), it.getValues());
        }
    }

    public ArrayOfDoublesCompactSketch getResult(WritableMemory dstMem) {
        if (this.sketch_.getRetainedEntries() > this.sketch_.getNominalEntries()) {
            this.theta_ = Math.min(this.theta_, this.sketch_.getNewTheta());
        }
        if (dstMem == null) {
            return new HeapArrayOfDoublesCompactSketch(this.sketch_, this.theta_);
        }
        return new DirectArrayOfDoublesCompactSketch(this.sketch_, this.theta_, dstMem);
    }

    public ArrayOfDoublesCompactSketch getResult() {
        return this.getResult(null);
    }

    public abstract void reset();

    public byte[] toByteArray() {
        int sizeBytes = 16 + this.sketch_.getSerializedSizeBytes();
        byte[] byteArray = new byte[sizeBytes];
        WritableMemory mem = WritableMemory.wrap((byte[])byteArray);
        mem.putByte(0L, (byte)1);
        mem.putByte(1L, (byte)1);
        mem.putByte(2L, (byte)Family.TUPLE.getID());
        mem.putByte(3L, (byte)SerializerDeserializer.SketchType.ArrayOfDoublesUnion.ordinal());
        mem.putLong(8L, this.theta_);
        this.sketch_.serializeInto(mem.writableRegion(16L, mem.getCapacity() - 16L));
        return byteArray;
    }

    public static int getMaxBytes(int nomEntries, int numValues) {
        return ArrayOfDoublesQuickSelectSketch.getMaxBytes(nomEntries, numValues);
    }

    void setThetaLong(long theta) {
        this.theta_ = theta;
    }

    static ArrayOfDoublesUnion wrapUnionImpl(WritableMemory mem, long seed, boolean isWritable) {
        DirectArrayOfDoublesUnion union;
        SerializerDeserializer.SketchType type = SerializerDeserializer.getSketchType((Memory)mem);
        if (type == SerializerDeserializer.SketchType.ArrayOfDoublesQuickSelectSketch) {
            DirectArrayOfDoublesUnion union2;
            if (isWritable) {
                DirectArrayOfDoublesQuickSelectSketch sketch = new DirectArrayOfDoublesQuickSelectSketch(mem, seed);
                union2 = new DirectArrayOfDoublesUnion(sketch, mem);
            } else {
                DirectArrayOfDoublesQuickSelectSketchR sketch = new DirectArrayOfDoublesQuickSelectSketchR((Memory)mem, seed);
                union2 = new DirectArrayOfDoublesUnionR(sketch, mem);
            }
            return union2;
        }
        byte version = mem.getByte(1L);
        if (version != 1) {
            throw new SketchesArgumentException("Serial version mismatch. Expected: 1, actual: " + version);
        }
        SerializerDeserializer.validateFamily(mem.getByte(2L), mem.getByte(0L));
        SerializerDeserializer.validateType(mem.getByte(3L), SerializerDeserializer.SketchType.ArrayOfDoublesUnion);
        if (isWritable) {
            WritableMemory sketchMem = mem.writableRegion(16L, mem.getCapacity() - 16L);
            DirectArrayOfDoublesQuickSelectSketch sketch = new DirectArrayOfDoublesQuickSelectSketch(sketchMem, seed);
            union = new DirectArrayOfDoublesUnion(sketch, mem);
        } else {
            Memory sketchMem = mem.region(16L, mem.getCapacity() - 16L);
            DirectArrayOfDoublesQuickSelectSketchR sketch = new DirectArrayOfDoublesQuickSelectSketchR(sketchMem, seed);
            union = new DirectArrayOfDoublesUnionR(sketch, mem);
        }
        union.theta_ = mem.getLong(8L);
        return union;
    }
}

