/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.hc.client5.http.AuthenticationStrategy;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.function.Factory;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Timeout;
import org.opensearch.client.Node;
import org.opensearch.client.NodeSelector;
import org.opensearch.client.RestClient;

public final class RestClientBuilder {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 1000;
    public static final int DEFAULT_RESPONSE_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_MAX_CONN_PER_ROUTE = 10;
    public static final int DEFAULT_MAX_CONN_TOTAL = 30;
    private static final Header[] EMPTY_HEADERS = new Header[0];
    private final List<Node> nodes;
    private Header[] defaultHeaders = EMPTY_HEADERS;
    private RestClient.FailureListener failureListener;
    private HttpClientConfigCallback httpClientConfigCallback;
    private RequestConfigCallback requestConfigCallback;
    private String pathPrefix;
    private NodeSelector nodeSelector = NodeSelector.ANY;
    private boolean strictDeprecationMode = false;
    private boolean compressionEnabled = false;
    private Optional<Boolean> chunkedEnabled;

    RestClientBuilder(List<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        for (Node node : nodes) {
            if (node != null) continue;
            throw new IllegalArgumentException("node cannot be null");
        }
        this.nodes = nodes;
        this.chunkedEnabled = Optional.empty();
    }

    public RestClientBuilder setDefaultHeaders(Header[] defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders must not be null");
        for (Header defaultHeader : defaultHeaders) {
            Objects.requireNonNull(defaultHeader, "default header must not be null");
        }
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public RestClientBuilder setFailureListener(RestClient.FailureListener failureListener) {
        Objects.requireNonNull(failureListener, "failureListener must not be null");
        this.failureListener = failureListener;
        return this;
    }

    public RestClientBuilder setHttpClientConfigCallback(HttpClientConfigCallback httpClientConfigCallback) {
        Objects.requireNonNull(httpClientConfigCallback, "httpClientConfigCallback must not be null");
        this.httpClientConfigCallback = httpClientConfigCallback;
        return this;
    }

    public RestClientBuilder setRequestConfigCallback(RequestConfigCallback requestConfigCallback) {
        Objects.requireNonNull(requestConfigCallback, "requestConfigCallback must not be null");
        this.requestConfigCallback = requestConfigCallback;
        return this;
    }

    public RestClientBuilder setPathPrefix(String pathPrefix) {
        this.pathPrefix = RestClientBuilder.cleanPathPrefix(pathPrefix);
        return this;
    }

    public static String cleanPathPrefix(String pathPrefix) {
        Objects.requireNonNull(pathPrefix, "pathPrefix must not be null");
        if (pathPrefix.isEmpty()) {
            throw new IllegalArgumentException("pathPrefix must not be empty");
        }
        String cleanPathPrefix = pathPrefix;
        if (!cleanPathPrefix.startsWith("/")) {
            cleanPathPrefix = "/" + cleanPathPrefix;
        }
        if (cleanPathPrefix.endsWith("/") && cleanPathPrefix.length() > 1 && (cleanPathPrefix = cleanPathPrefix.substring(0, cleanPathPrefix.length() - 1)).endsWith("/")) {
            throw new IllegalArgumentException("pathPrefix is malformed. too many trailing slashes: [" + pathPrefix + "]");
        }
        return cleanPathPrefix;
    }

    public RestClientBuilder setNodeSelector(NodeSelector nodeSelector) {
        Objects.requireNonNull(nodeSelector, "nodeSelector must not be null");
        this.nodeSelector = nodeSelector;
        return this;
    }

    public RestClientBuilder setStrictDeprecationMode(boolean strictDeprecationMode) {
        this.strictDeprecationMode = strictDeprecationMode;
        return this;
    }

    public RestClientBuilder setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
        return this;
    }

    public RestClientBuilder setChunkedEnabled(boolean chunkedEnabled) {
        this.chunkedEnabled = Optional.of(chunkedEnabled);
        return this;
    }

    public RestClient build() {
        if (this.failureListener == null) {
            this.failureListener = new RestClient.FailureListener();
        }
        CloseableHttpAsyncClient httpClient = AccessController.doPrivileged(this::createHttpClient);
        RestClient restClient = null;
        restClient = this.chunkedEnabled.isPresent() ? new RestClient(httpClient, this.defaultHeaders, this.nodes, this.pathPrefix, this.failureListener, this.nodeSelector, this.strictDeprecationMode, this.compressionEnabled, this.chunkedEnabled.get()) : new RestClient(httpClient, this.defaultHeaders, this.nodes, this.pathPrefix, this.failureListener, this.nodeSelector, this.strictDeprecationMode, this.compressionEnabled);
        httpClient.start();
        return restClient;
    }

    private CloseableHttpAsyncClient createHttpClient() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)1000L)).setResponseTimeout(Timeout.ofMilliseconds((long)30000L));
        if (this.requestConfigCallback != null) {
            requestConfigBuilder = this.requestConfigCallback.customizeRequestConfig(requestConfigBuilder);
        }
        try {
            TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(SSLContext.getDefault()).setTlsDetailsFactory((Factory)new Factory<SSLEngine, TlsDetails>(){

                public TlsDetails create(SSLEngine sslEngine) {
                    return new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol());
                }
            }).build();
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setMaxConnPerRoute(10).setMaxConnTotal(30).setTlsStrategy(tlsStrategy).build();
            HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClientBuilder.create().setDefaultRequestConfig(requestConfigBuilder.build()).setConnectionManager((AsyncClientConnectionManager)connectionManager).setTargetAuthenticationStrategy((AuthenticationStrategy)DefaultAuthenticationStrategy.INSTANCE).disableAutomaticRetries();
            if (this.httpClientConfigCallback != null) {
                httpClientBuilder = this.httpClientConfigCallback.customizeHttpClient(httpClientBuilder);
            }
            HttpAsyncClientBuilder finalBuilder = httpClientBuilder;
            return AccessController.doPrivileged(() -> ((HttpAsyncClientBuilder)finalBuilder).build());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("could not create the default ssl context", e);
        }
    }

    public static interface HttpClientConfigCallback {
        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder var1);
    }

    public static interface RequestConfigCallback {
        public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder var1);
    }
}

