/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core.resthandler;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.core.action.node.ScheduledJobsStatsRequest;
import org.opensearch.core.common.Strings;
import org.opensearch.rest.RestRequest;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JO\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u001220\u0010\u0013\u001a,\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0014\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R)\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/alerting/core/resthandler/StatsRequestUtils;", "", "<init>", "()V", "JOB_SCHEDULING_METRICS", "", "JOBS_INFO", "METRICS", "", "Lkotlin/Function1;", "Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsRequest;", "", "getMETRICS", "()Ljava/util/Map;", "getStatsRequest", "request", "Lorg/opensearch/rest/RestRequest;", "showAlertingV2ScheduledJobs", "", "unrecognizedFn", "Lkotlin/Function4;", "", "(Lorg/opensearch/rest/RestRequest;Ljava/lang/Boolean;Lkotlin/jvm/functions/Function4;)Lorg/opensearch/alerting/core/action/node/ScheduledJobsStatsRequest;", "alerting-core"})
public final class StatsRequestUtils {
    @NotNull
    public static final StatsRequestUtils INSTANCE = new StatsRequestUtils();
    @NotNull
    public static final String JOB_SCHEDULING_METRICS = "job_scheduling_metrics";
    @NotNull
    public static final String JOBS_INFO = "jobs_info";
    @NotNull
    private static final Map<String, Function1<ScheduledJobsStatsRequest, Unit>> METRICS;

    private StatsRequestUtils() {
    }

    @NotNull
    public final Map<String, Function1<ScheduledJobsStatsRequest, Unit>> getMETRICS() {
        return METRICS;
    }

    @NotNull
    public final ScheduledJobsStatsRequest getStatsRequest(@NotNull RestRequest request, @Nullable Boolean showAlertingV2ScheduledJobs, @NotNull Function4<? super RestRequest, ? super Set<String>, ? super Set<String>, ? super String, String> unrecognizedFn) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(unrecognizedFn, (String)"unrecognizedFn");
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        Set metrics = Strings.tokenizeByCommaToSet((String)request.param("metric"));
        Intrinsics.checkNotNull((Object)nodesIds);
        ScheduledJobsStatsRequest scheduledJobsStatsRequest = new ScheduledJobsStatsRequest(nodesIds, showAlertingV2ScheduledJobs);
        scheduledJobsStatsRequest.timeout(request.param("timeout"));
        if (metrics.isEmpty()) {
            return scheduledJobsStatsRequest;
        }
        if (metrics.size() == 1 && metrics.contains("_all")) {
            scheduledJobsStatsRequest.all();
        } else {
            if (metrics.contains("_all")) {
                Locale locale = Locale.ROOT;
                String string = "request [%s] contains _all and individual metrics [%s]";
                Object[] objectArray = new Object[]{request.path(), request.param("metric")};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                throw new IllegalArgumentException(string2);
            }
            scheduledJobsStatsRequest.clear();
            TreeSet<String> invalidMetrics = new TreeSet<String>();
            for (String metric : metrics) {
                Function1<ScheduledJobsStatsRequest, Unit> handler = METRICS.get(metric);
                if (handler != null) {
                    handler.invoke((Object)scheduledJobsStatsRequest);
                    continue;
                }
                invalidMetrics.add(metric);
            }
            if (!invalidMetrics.isEmpty()) {
                throw new IllegalArgumentException((String)unrecognizedFn.invoke((Object)request, invalidMetrics, METRICS.keySet(), (Object)"metric"));
            }
        }
        return scheduledJobsStatsRequest;
    }

    private static final Unit METRICS$lambda$0(ScheduledJobsStatsRequest it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        it.setJobSchedulingMetrics(true);
        return Unit.INSTANCE;
    }

    private static final Unit METRICS$lambda$1(ScheduledJobsStatsRequest it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        it.setJobsInfo(true);
        return Unit.INSTANCE;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JOB_SCHEDULING_METRICS, StatsRequestUtils::METRICS$lambda$0), TuplesKt.to((Object)JOBS_INFO, StatsRequestUtils::METRICS$lambda$1)};
        METRICS = MapsKt.mapOf((Pair[])pairArray);
    }
}

