/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import org.opensearch.OpenSearchException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.search.internal.ShardSearchContextId;

public class SearchContextMissingException
extends OpenSearchException {
    private final ShardSearchContextId contextId;

    public SearchContextMissingException(ShardSearchContextId contextId) {
        super("No search context found for id [" + contextId.getId() + "]", new Object[0]);
        this.contextId = contextId;
    }

    public ShardSearchContextId contextId() {
        return this.contextId;
    }

    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }

    public SearchContextMissingException(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.contextId.writeTo(out);
    }
}

