/*
 * Decompiled with CFR 0.152.
 */
package de.danielnaber.jwordsplitter;

import de.danielnaber.jwordsplitter.GermanWordSplitter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

final class Example2 {
    private Example2() {
    }

    public static void main(String[] args) throws IOException {
        GermanWordSplitter splitter = new GermanWordSplitter(true);
        splitter.setMinimumWordLength(3);
        splitter.setStrictMode(true);
        GermanWordSplitter nonStrictSplitter = new GermanWordSplitter(true);
        nonStrictSplitter.setMinimumWordLength(3);
        nonStrictSplitter.setStrictMode(false);
        List<Object> words = new ArrayList();
        if (args.length == 1) {
            Scanner sc = new Scanner(new File(args[0]));
            while (sc.hasNextLine()) {
                words.add(sc.nextLine());
            }
        } else {
            String wordsInput = "Bahnhofsuhr, Bahnhofssanierung";
            words = Arrays.asList(wordsInput.split(",\\s*"));
        }
        for (String string : words) {
            List<String> parts = splitter.splitWord(string);
            if (parts.size() == 1) {
                parts = nonStrictSplitter.splitWord(string);
            }
            System.out.println(String.join((CharSequence)", ", parts));
        }
    }
}

