/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.policy;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.admin.PermissionService;
import org.keycloak.authorization.admin.PolicyTypeResourceService;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.representations.idm.authorization.AbstractPolicyRepresentation;
import org.keycloak.representations.idm.authorization.UmaPermissionRepresentation;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.util.JsonSerialization;

public class UserManagedPermissionService {
    private final ResourceServer resourceServer;
    private final Identity identity;
    private final AuthorizationProvider authorization;
    private final PermissionService delegate;

    public UserManagedPermissionService(KeycloakIdentity identity, ResourceServer resourceServer, AuthorizationProvider authorization, AdminEventBuilder eventBuilder) {
        this.identity = identity;
        this.resourceServer = resourceServer;
        this.authorization = authorization;
        this.delegate = new PermissionService(resourceServer, authorization, null, eventBuilder);
    }

    @POST
    @Path(value="{resourceId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response create(@PathParam(value="resourceId") String resourceId, UmaPermissionRepresentation representation) {
        if (representation.getId() != null) {
            throw new ErrorResponseException("invalid_request", "Newly created uma policies should not have an id", Response.Status.BAD_REQUEST);
        }
        this.checkRequest(resourceId, representation);
        representation.addResource(resourceId);
        representation.setOwner(this.identity.getId());
        return this.findById(this.delegate.create((AbstractPolicyRepresentation)representation).getId());
    }

    @Path(value="{policyId}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response update(@PathParam(value="policyId") String policyId, String payload) {
        UmaPermissionRepresentation representation;
        try {
            representation = (UmaPermissionRepresentation)JsonSerialization.readValue((String)payload, UmaPermissionRepresentation.class);
        }
        catch (IOException e) {
            throw new ErrorResponseException("invalid_request", "Failed to parse representation", Response.Status.BAD_REQUEST);
        }
        String resourceId = this.getAssociatedResourceId(policyId);
        Set resources = Optional.ofNullable(representation.getResources()).orElse(Set.of());
        if (resources.isEmpty() || resources.size() == 1 && resources.contains(resourceId)) {
            this.checkRequest(resourceId, representation);
            return ((PolicyTypeResourceService)PolicyTypeResourceService.class.cast(this.delegate.getResource(policyId))).update(payload);
        }
        throw new ErrorResponseException("invalid_request", "Uma permission resource cannot be changed", Response.Status.BAD_REQUEST);
    }

    @Path(value="{policyId}")
    @DELETE
    public Response delete(@PathParam(value="policyId") String policyId) {
        this.checkRequest(this.getAssociatedResourceId(policyId), null);
        ((PolicyTypeResourceService)PolicyTypeResourceService.class.cast(this.delegate.getResource(policyId))).delete();
        return Response.noContent().build();
    }

    @Path(value="{policyId}")
    @GET
    @Produces(value={"application/json"})
    public Response findById(@PathParam(value="policyId") String policyId) {
        this.checkRequest(this.getAssociatedResourceId(policyId), null);
        return ((PolicyTypeResourceService)PolicyTypeResourceService.class.cast(this.delegate.getResource(policyId))).findById(null);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Response find(@QueryParam(value="name") String name, @QueryParam(value="resource") String resource, @QueryParam(value="scope") String scope, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResult) {
        return this.delegate.findAll(null, name, "uma", null, resource, scope, true, this.identity.getId(), null, firstResult, maxResult);
    }

    private Policy getPolicy(@PathParam(value="policyId") String policyId) {
        Policy existing = this.authorization.getStoreFactory().getPolicyStore().findById(this.resourceServer, policyId);
        if (existing == null) {
            throw new ErrorResponseException("invalid_request", "Policy with [" + policyId + "] does not exist", Response.Status.NOT_FOUND);
        }
        return existing;
    }

    private void checkRequest(String resourceId, UmaPermissionRepresentation representation) {
        ResourceStore resourceStore = this.authorization.getStoreFactory().getResourceStore();
        Resource resource = resourceStore.findById(this.resourceServer, resourceId);
        if (resource == null) {
            throw new ErrorResponseException("invalid_request", "Resource [" + resourceId + "] cannot be found", Response.Status.BAD_REQUEST);
        }
        if (!resource.getOwner().equals(this.identity.getId())) {
            throw new ErrorResponseException("invalid_request", "Only resource owner can access policies for resource [" + resourceId + "]", Response.Status.BAD_REQUEST);
        }
        if (!resource.isOwnerManagedAccess()) {
            throw new ErrorResponseException("invalid_request", "Only resources with owner managed accessed can have policies", Response.Status.BAD_REQUEST);
        }
        if (!this.resourceServer.isAllowRemoteResourceManagement()) {
            throw new ErrorResponseException("request_not_supported", "Remote Resource Management not enabled on resource server [" + this.resourceServer.getId() + "]", Response.Status.FORBIDDEN);
        }
        if (representation != null) {
            Set resourceScopes = resource.getScopes().stream().map(scope -> scope.getName()).collect(Collectors.toSet());
            Set scopes = representation.getScopes();
            if (scopes == null || scopes.isEmpty()) {
                scopes = resourceScopes;
                representation.setScopes(scopes);
            }
            if (!resourceScopes.containsAll(scopes)) {
                throw new ErrorResponseException("invalid_request", "Some of the scopes [" + String.valueOf(scopes) + "] are not valid for resource [" + resourceId + "]", Response.Status.BAD_REQUEST);
            }
        }
    }

    private String getAssociatedResourceId(String policyId) {
        return ((Resource)this.getPolicy(policyId).getResources().iterator().next()).getId();
    }
}

