/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultiOnCompletionInvoke<T>
extends AbstractMultiOperator<T, T> {
    private final Runnable action;

    public MultiOnCompletionInvoke(Multi<? extends T> upstream, Runnable action) {
        super(upstream);
        this.action = action;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnCompletionInvokeProcessor(ParameterValidation.nonNull(downstream, "downstream")));
    }

    class MultiOnCompletionInvokeProcessor
    extends MultiOperatorProcessor<T, T> {
        private final AtomicBoolean actionInvoked;

        public MultiOnCompletionInvokeProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.actionInvoked = new AtomicBoolean();
        }

        @Override
        public void onCompletion() {
            if (this.actionInvoked.compareAndSet(false, true)) {
                try {
                    MultiOnCompletionInvoke.this.action.run();
                    super.onCompletion();
                }
                catch (Throwable err) {
                    super.onFailure(err);
                }
            }
        }
    }
}

