/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.TokenIntrospectionTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;
import org.keycloak.utils.RoleResolveUtil;

public class RoleNameMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
UserInfoTokenMapper,
TokenIntrospectionTokenMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String ROLE_CONFIG = "role";
    public static String NEW_ROLE_NAME = "new.role.name";
    public static final String PROVIDER_ID = "oidc-role-name-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Role Name Mapper";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Map an assigned role to a new name or position in the token.";
    }

    public int getPriority() {
        return 10;
    }

    @Override
    public AccessToken transformUserInfoToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        this.setClaim((IDToken)token, mappingModel, userSession, session, clientSessionCtx);
        return token;
    }

    @Override
    public AccessToken transformAccessToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        this.setClaim((IDToken)token, mappingModel, userSession, session, clientSessionCtx);
        return token;
    }

    @Override
    public AccessToken transformIntrospectionToken(AccessToken token, ProtocolMapperModel mappingModel, KeycloakSession session, UserSessionModel userSession, ClientSessionContext clientSessionCtx) {
        this.setClaim((IDToken)token, mappingModel, userSession, session, clientSessionCtx);
        return token;
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession session, ClientSessionContext clientSessionCtx) {
        String role = (String)mappingModel.getConfig().get(ROLE_CONFIG);
        String newName = (String)mappingModel.getConfig().get(NEW_ROLE_NAME);
        String[] scopedRole = KeycloakModelUtils.parseRole((String)role);
        String[] newScopedRole = KeycloakModelUtils.parseRole((String)newName);
        String appName = scopedRole[0];
        String roleName = scopedRole[1];
        if (appName != null) {
            access = RoleResolveUtil.getResolvedClientRoles(session, clientSessionCtx, appName, false);
            if (access == null) {
                return;
            }
            if (!access.getRoles().contains(roleName)) {
                return;
            }
            access.getRoles().remove(roleName);
        } else {
            access = RoleResolveUtil.getResolvedRealmRoles(session, clientSessionCtx, false);
            if (access == null || !access.getRoles().contains(roleName)) {
                return;
            }
            access.getRoles().remove(roleName);
        }
        String newAppName = newScopedRole[0];
        String newRoleName = newScopedRole[1];
        AccessToken.Access access = null;
        access = newAppName == null ? RoleResolveUtil.getResolvedRealmRoles(session, clientSessionCtx, true) : RoleResolveUtil.getResolvedClientRoles(session, clientSessionCtx, newAppName, true);
        access.addRole(newRoleName);
    }

    public static ProtocolMapperModel create(String name, String role, String newName) {
        String mapperId = PROVIDER_ID;
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(mapperId);
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(ROLE_CONFIG, role);
        config.put(NEW_ROLE_NAME, newName);
        mapper.setConfig(config);
        return mapper;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ROLE_CONFIG);
        property.setLabel("Role");
        property.setHelpText("Role name you want changed.  Click 'Select Role' button to browse roles, or just type it in the textbox.  To reference a client role the syntax is clientname.clientrole, i.e. myclient.myrole");
        property.setType("Role");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(NEW_ROLE_NAME);
        property.setLabel("New Role Name");
        property.setHelpText("The new role name.  The new name format corresponds to where in the access token the role will be mapped to.  So, a new name of 'myapp.newname' will map the role to that position in the access token.  A new name of 'newname' will map the role to the realm roles in the token.");
        property.setType("String");
        configProperties.add(property);
    }
}

