/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.keycloak.models.oid4vci.CredentialScopeModel;
import org.keycloak.util.JsonSerialization;
import org.keycloak.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DisplayObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(DisplayObject.class);
    @JsonIgnore
    private static final String NAME_KEY = "name";
    @JsonIgnore
    private static final String LOCALE_KEY = "locale";
    @JsonIgnore
    private static final String LOGO_KEY = "logo";
    @JsonIgnore
    private static final String DESCRIPTION_KEY = "description";
    @JsonIgnore
    private static final String BG_COLOR_KEY = "background_color";
    @JsonIgnore
    private static final String TEXT_COLOR_KEY = "text_color";
    @JsonIgnore
    private static final String BG_IMAGE_KEY = "background_image";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="locale")
    private String locale;
    @JsonProperty(value="logo")
    private LogoObject logo;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="background_color")
    private String backgroundColor;
    @JsonProperty(value="text_color")
    private String textColor;
    @JsonProperty(value="background_image")
    private BackgroundImageObject backgroundImage;

    public static List<DisplayObject> parse(CredentialScopeModel credentialScope) {
        String display = credentialScope.getVcDisplay();
        if (StringUtil.isBlank((String)display)) {
            return null;
        }
        TypeReference<List<DisplayObject>> typeReference = new TypeReference<List<DisplayObject>>(){};
        try {
            return (List)JsonSerialization.mapper.readValue(display, (TypeReference)typeReference);
        }
        catch (JsonProcessingException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            LOGGER.info(String.format("Failed to parse display-metadata for credential: %s", credentialScope.getName()), (Object)e.getMessage());
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public DisplayObject setName(String name) {
        this.name = name;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public DisplayObject setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public LogoObject getLogo() {
        return this.logo;
    }

    public DisplayObject setLogo(LogoObject logo) {
        this.logo = logo;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public DisplayObject setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public DisplayObject setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public String getTextColor() {
        return this.textColor;
    }

    public DisplayObject setTextColor(String textColor) {
        this.textColor = textColor;
        return this;
    }

    public BackgroundImageObject getBackgroundImage() {
        return this.backgroundImage;
    }

    public DisplayObject setBackgroundImage(BackgroundImageObject backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    public String toJsonString() {
        try {
            return JsonSerialization.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static DisplayObject fromJsonString(String jsonString) {
        try {
            return (DisplayObject)JsonSerialization.readValue((String)jsonString, DisplayObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisplayObject)) {
            return false;
        }
        DisplayObject that = (DisplayObject)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getLocale() != null ? !this.getLocale().equals(that.getLocale()) : that.getLocale() != null) {
            return false;
        }
        if (this.getLogo() != null ? !this.getLogo().equals(that.getLogo()) : that.getLogo() != null) {
            return false;
        }
        if (this.getDescription() != null ? !this.getDescription().equals(that.getDescription()) : that.getDescription() != null) {
            return false;
        }
        if (this.getBackgroundColor() != null ? !this.getBackgroundColor().equals(that.getBackgroundColor()) : that.getBackgroundColor() != null) {
            return false;
        }
        if (this.getBackgroundImage() != null ? !this.getBackgroundImage().equals(that.getBackgroundImage()) : that.getBackgroundImage() != null) {
            return false;
        }
        return this.getTextColor() != null ? this.getTextColor().equals(that.getTextColor()) : that.getTextColor() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + (this.getLocale() != null ? this.getLocale().hashCode() : 0);
        result = 31 * result + (this.getLogo() != null ? this.getLogo().hashCode() : 0);
        result = 31 * result + (this.getDescription() != null ? this.getDescription().hashCode() : 0);
        result = 31 * result + (this.getBackgroundColor() != null ? this.getBackgroundColor().hashCode() : 0);
        result = 31 * result + (this.getBackgroundImage() != null ? this.getBackgroundImage().hashCode() : 0);
        result = 31 * result + (this.getTextColor() != null ? this.getTextColor().hashCode() : 0);
        return result;
    }

    public String toString() {
        try {
            return JsonSerialization.mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class LogoObject {
        @JsonProperty(value="uri")
        private String uri;
        @JsonProperty(value="alt_text")
        private String altText;

        public String getUri() {
            return this.uri;
        }

        public LogoObject setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public String getAltText() {
            return this.altText;
        }

        public LogoObject setAltText(String altText) {
            this.altText = altText;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LogoObject)) {
                return false;
            }
            LogoObject that = (LogoObject)o;
            return Objects.equals(this.uri, that.uri) && Objects.equals(this.altText, that.altText);
        }

        public int hashCode() {
            return Objects.hash(this.uri, this.altText);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class BackgroundImageObject {
        @JsonProperty(value="uri")
        private String uri;

        public String getUri() {
            return this.uri;
        }

        public BackgroundImageObject setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BackgroundImageObject)) {
                return false;
            }
            BackgroundImageObject that = (BackgroundImageObject)o;
            return Objects.equals(this.uri, that.uri);
        }

        public int hashCode() {
            return Objects.hash(this.uri);
        }
    }
}

