/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import org.gradle.api.internal.tasks.testing.ClassTestDefinition;
import org.gradle.api.internal.tasks.testing.RequiresTestFrameworkTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.TestDefinitionConsumer;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.junit.AbstractJUnitTestDefinitionProcessor;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestExecutor;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class JUnitTestDefinitionProcessor
extends AbstractJUnitTestDefinitionProcessor<ClassTestDefinition> {
    private final IdGenerator<?> idGenerator;
    private final JUnitSpec spec;
    private final Clock clock;

    public JUnitTestDefinitionProcessor(JUnitSpec spec, IdGenerator<?> idGenerator, ActorFactory actorFactory, Clock clock) {
        super(actorFactory);
        this.spec = spec;
        this.idGenerator = idGenerator;
        this.clock = clock;
    }

    public void assertTestFrameworkAvailable() {
        try {
            Class.forName("org.junit.runner.notification.RunListener");
        }
        catch (ClassNotFoundException e) {
            throw new RequiresTestFrameworkTestDefinitionProcessor.TestFrameworkNotAvailableException("Failed to load JUnit 4.  Please ensure that the JUnit 4 library is available on the test's runtime classpath.");
        }
    }

    @Override
    protected TestDefinitionConsumer<ClassTestDefinition> createTestExecutor(Actor resultProcessorActor) {
        TestResultProcessor threadSafeResultProcessor = (TestResultProcessor)resultProcessorActor.getProxy(TestResultProcessor.class);
        return new JUnitTestExecutor(Thread.currentThread().getContextClassLoader(), this.spec, this.clock, this.idGenerator, threadSafeResultProcessor);
    }
}

