---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token HubSpot private app API token'
---

## Description

The response body contains content that matches the pattern of a HubSpot private app API token was identified. Private apps allow you to use HubSpot's APIs to access specific data from your HubSpot account and can be restricted by setting specific scopes. A malicious actor with access to this token can call API endpoints with the same levels as those set in the scope of the application. This could be anywhere from only reading marketing campaigns to accessing user and account information and sending emails.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To rotate a private app API token:

- Sign in to your HubSpot account at <https://app.hubspot.com/>
- In the left-hand menu, hover over the database icon and select "Integrations"
- Find the private app that has the identified token and select its name
- Select the "Auth" tab in the top of the page
- In the "Access token" section of the page, select "Rotate"
- Select "Rotate and expire this token now" when prompted
- Select "Rotate now" in the "Rotate access token now?" dialog

For more information, please see [HubSpot's documentation on private apps](https://developers.hubspot.com/beta-docs/guides/apps/private-apps/overview)

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.60 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
