/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.fibs.geotag.License;
import org.fibs.geotag.Settings;
import org.fibs.geotag.Version;
import org.fibs.geotag.gui.flattr.FlattrButton;
import org.fibs.geotag.util.BrowserLauncher;
import org.fibs.geotag.util.ImageUtil;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AboutDialog
extends JDialog
implements HyperlinkListener {
    private static final I18n i18n = I18nFactory.getI18n(AboutDialog.class);
    private static final String ICON_NAME = "images/geotag-48.png";
    private static final int BORDER_SIZE = 20;

    public AboutDialog(Window owner, String title) {
        super(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        System.out.println(title);
        Image image = ImageUtil.loadImage(ICON_NAME);
        ImageIcon icon = new ImageIcon(image);
        JLabel logo = new JLabel(icon);
        logo.setBorder(new EmptyBorder(20, 0, 20, 0));
        this.add((Component)logo, "North");
        JPanel panel = new JPanel(new BorderLayout());
        JTextPane header = new JTextPane();
        header.setContentType("text/html");
        header.setEditable(false);
        header.setBackground(this.getContentPane().getBackground());
        header.addHyperlinkListener(this);
        StringBuilder message = new StringBuilder();
        message.append("<center><font size=\"+1\"<b>");
        message.append("Geotag").append(' ').append(Version.VERSION).append(' ').append("(Build ").append(Version.BUILD_NUMBER).append(')');
        message.append("</b></font><br><br>");
        message.append(Version.BUILD_DATE).append("<br>");
        message.append("<a href=\"").append("http://geotag.sourceforge.net").append("\">").append("http://geotag.sourceforge.net").append("</a>");
        message.append("<br>");
        message.append(i18n.tr("Copyright")).append(' ').append('\u00a9').append(' ');
        message.append("2007-2017").append(' ');
        message.append("Andreas Schneider");
        message.append("<br><br></center>");
        header.setText(message.toString());
        panel.add((Component)header, "North");
        JLabel license = new JLabel();
        Font font = license.getFont();
        license.setFont(font.deriveFont(0));
        message = new StringBuilder("<html><center>");
        List<String> licenseInfo = License.licenseInfo();
        for (String line : licenseInfo) {
            message.append(line).append("<br>");
        }
        message.append("</center></html>");
        license.setText(message.toString());
        panel.add((Component)license, "Center");
        JTextPane footer = new JTextPane();
        footer.setContentType("text/html");
        footer.setEditable(false);
        footer.setBackground(this.getContentPane().getBackground());
        footer.addHyperlinkListener(this);
        footer.setText("<center><a href=\"http://www.gnu.org/licenses\">http://www.gnu.org/licenses</a></center>");
        panel.add((Component)footer, "South");
        panel.setBorder(BorderFactory.createEmptyBorder(0, 20, 20, 20));
        this.add((Component)panel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        String ok = i18n.tr("OK");
        JButton okButton = new JButton(ok);
        FontMetrics fontMetrics = okButton.getFontMetrics(okButton.getFont());
        int preferredWidth = fontMetrics.stringWidth(ok) * 3;
        Dimension preferredSize = okButton.getPreferredSize();
        preferredSize.width = preferredWidth;
        okButton.setPreferredSize(preferredSize);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
        buttonPanel.add(okButton);
        FlattrButton flattrButton = new FlattrButton();
        buttonPanel.add(flattrButton);
        this.add((Component)buttonPanel, "South");
        this.pack();
        if (owner != null) {
            this.setLocationRelativeTo(owner);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            BrowserLauncher.openURL(Settings.get(Settings.SETTING.BROWSER, null), event.getURL().toString());
        }
    }

    public static void main(String[] args) {
        new AboutDialog(null, "About Geotag").setVisible(true);
    }
}

