/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.util.List;
import javax.swing.SwingUtilities;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.outline.MapAwareOutlinePane;
import org.freeplane.view.swing.map.outline.SelectionSynchronizationTrigger;
import org.freeplane.view.swing.map.outline.TreeNode;

class OutlineSelectionBridge {
    private final MapAwareOutlinePane outlinePane;

    OutlineSelectionBridge(MapAwareOutlinePane outlinePane) {
        this.outlinePane = outlinePane;
    }

    public void selectMapNodeById(String nodeId) {
        MapView mv = this.outlinePane.getCurrentMapView();
        if (mv == null) {
            return;
        }
        Controller controller = Controller.getCurrentController();
        NodeModel current = null;
        IMapSelection selection = controller.getSelection();
        if (selection != null) {
            current = selection.getSelected();
        }
        if (current != null && nodeId != null && nodeId.equals(current.getID())) {
            return;
        }
        NodeModel target = mv.getMap().getNodeForID(nodeId);
        if (target == null) {
            return;
        }
        MapController mapController = mv.getModeController().getMapController();
        mapController.displayNode(target);
        NodeView nodeView = mv.getNodeView(target);
        mv.selectAsTheOnlyOneSelected(nodeView, false);
        mapController.scrollNodeTreeAfterSelect(nodeView.getNode());
        SwingUtilities.invokeLater(this::focusMapNode);
    }

    void synchronizeOutlineSelection(SelectionSynchronizationTrigger selectionSynchronizationTrigger, boolean requestFocusInWindow) {
        this.outlinePane.synchronizeOutlineSelection(selectionSynchronizationTrigger, requestFocusInWindow);
    }

    private void focusMapNode() {
        MapView mv = this.outlinePane.getCurrentMapView();
        if (mv == null) {
            return;
        }
        mv.getSelected().getMainView().requestFocusInWindow();
    }

    List<TreeNode> collectNodesToSelection(TreeNode ancestor) {
        return this.outlinePane.collectNodesToSelection(ancestor);
    }
}

