/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.tasks.nativetool.NativeToolUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractImportExportSettings<BASE_OBJECT extends DBSObject>
extends AbstractNativeToolSettings<BASE_OBJECT> {
    private static final Log log = Log.getLog(AbstractImportExportSettings.class);
    private String outputFolderPattern;
    private String outputFilePattern;

    public AbstractImportExportSettings() {
    }

    public AbstractImportExportSettings(@NotNull DBPProject project) {
        super(project);
    }

    public String getOutputFolderPattern() {
        return this.outputFolderPattern;
    }

    public void setOutputFolderPattern(String outputFolderPattern) {
        this.outputFolderPattern = outputFolderPattern;
    }

    public String getOutputFilePattern() {
        return this.outputFilePattern;
    }

    public void setOutputFilePattern(String outputFilePattern) {
        this.outputFilePattern = outputFilePattern;
    }

    @Override
    public void loadSettingsFromInput(@NotNull List<BASE_OBJECT> inputObjects, @NotNull Map<String, Object> options) {
        super.loadSettingsFromInput(inputObjects, options);
        this.fillExportObjectsFromInput();
    }

    public void fillExportObjectsFromInput() {
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore store) throws DBException {
        this.outputFilePattern = store.getString("export.outputFilePattern");
        if (CommonUtils.isEmpty((String)this.outputFilePattern)) {
            this.outputFilePattern = "dump-${database}-${timestamp}.sql";
        }
        this.outputFolderPattern = CommonUtils.toString((Object)store.getString("export.outputFolder"));
        if (CommonUtils.isEmpty((String)this.outputFolderPattern)) {
            this.outputFolderPattern = RuntimeUtils.getUserHomeDir().getAbsolutePath();
        }
        super.loadSettings(runnableContext, store);
    }

    @Override
    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) {
        super.saveSettings(runnableContext, preferenceStore);
        preferenceStore.setValue("export.outputFilePattern", this.outputFilePattern);
        preferenceStore.setValue("export.outputFolder", this.outputFolderPattern);
    }

    protected String resolveVars(@NotNull DBSObjectContainer container, Collection<? extends DBSSchema> schemas, Collection<? extends DBSTable> tables, String pattern) {
        return GeneralUtils.replaceVariables((String)pattern, name -> {
            switch (name) {
                case "database": {
                    return container.getName();
                }
                case "host": {
                    return container.getDataSource().getContainer().getConnectionConfiguration().getHostName();
                }
                case "connection.type": {
                    return container.getDataSource().getContainer().getConnectionConfiguration().getConnectionType().getId();
                }
                case "schema": {
                    Iterator iterator;
                    Iterator iterator2 = iterator = schemas == null ? null : schemas.iterator();
                    if (iterator != null && iterator.hasNext()) {
                        return ((DBSSchema)iterator.next()).getName();
                    }
                    return container instanceof DBSStructContainer ? container.getName() : "null";
                }
                case "table": {
                    Iterator iterator;
                    Iterator iterator3 = iterator = tables == null ? null : tables.iterator();
                    if (iterator != null && iterator.hasNext()) {
                        return ((DBSTable)iterator.next()).getName();
                    }
                    return "null";
                }
                case "timestamp": {
                    return RuntimeUtils.getCurrentTimeStamp();
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
            }
            return NativeToolUtils.replaceVariables(name);
        });
    }
}

