/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.BorderData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BorderLayout
extends Layout {
    private static final String LAYOUT_KEY = BorderLayout.class.getName() + ".layoutData";
    private static final ToIntFunction<Point> WIDTH = p -> p.x;
    private static final ToIntFunction<Point> HEIGHT = p -> p.y;
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 0;
    public int controlSpacing = 0;
    public double widthDistributionFactor = 0.5;
    public double heightDistributionFactor = 0.5;

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        int height;
        int width;
        if (hHint > -1 && wHint > -1) {
            return new Point(wHint, hHint);
        }
        Stream<Map.Entry> children = Arrays.stream(composite.getChildren()).map(control -> this.borderDataControl(control, flushCache));
        Map<Integer, List<Map.Entry<Control, BorderData>>> regionMap = children.collect(Collectors.groupingBy(BorderLayout::region));
        if (wHint <= -1) {
            IntStream.Builder widthBuilder = IntStream.builder();
            int northWidth = this.getTotal(WIDTH, 128, regionMap);
            int southWidth = this.getTotal(WIDTH, 1024, regionMap);
            int centerWidth = this.type == 256 ? this.getTotal(WIDTH, 0x1000000, regionMap) : BorderLayout.getMax(WIDTH, 0x1000000, regionMap);
            int westWidth = BorderLayout.getMax(WIDTH, 16384, regionMap);
            int eastWidth = BorderLayout.getMax(WIDTH, 131072, regionMap);
            int middleWidth = westWidth + centerWidth + eastWidth;
            if (centerWidth > 0) {
                if (westWidth > 0) {
                    middleWidth += this.spacing;
                }
                if (eastWidth > 0) {
                    middleWidth += this.spacing;
                }
            } else if (westWidth > 0 && eastWidth > 0) {
                middleWidth += this.spacing;
            }
            widthBuilder.add(middleWidth);
            widthBuilder.add(northWidth);
            widthBuilder.add(southWidth);
            width = widthBuilder.build().max().orElse(0) + 2 * this.marginWidth;
        } else {
            width = wHint;
        }
        if (hHint <= -1) {
            IntStream.Builder heightBuilder = IntStream.builder();
            int northHeight = BorderLayout.getMax(HEIGHT, 128, regionMap);
            int southHeight = BorderLayout.getMax(HEIGHT, 1024, regionMap);
            int westHeight = this.getTotal(HEIGHT, 16384, regionMap);
            int eastHeight = this.getTotal(HEIGHT, 131072, regionMap);
            int centerHeight = this.type == 256 ? BorderLayout.getMax(HEIGHT, 0x1000000, regionMap) : this.getTotal(HEIGHT, 0x1000000, regionMap);
            if (centerHeight > 0) {
                if (northHeight > 0) {
                    centerHeight += this.spacing;
                }
                if (southHeight > 0) {
                    centerHeight += this.spacing;
                }
            }
            if (westHeight > 0) {
                if (northHeight > 0) {
                    westHeight += this.spacing;
                }
                if (southHeight > 0) {
                    westHeight += this.spacing;
                }
            }
            if (eastHeight > 0) {
                if (northHeight > 0) {
                    eastHeight += this.spacing;
                }
                if (southHeight > 0) {
                    eastHeight += this.spacing;
                }
            }
            int sum = northHeight + southHeight;
            heightBuilder.add(westHeight + sum);
            heightBuilder.add(centerHeight + sum);
            heightBuilder.add(eastHeight + sum);
            height = heightBuilder.build().max().orElse(0) + 2 * this.marginHeight;
        } else {
            height = hHint;
        }
        return new Point(width, height);
    }

    private int getTotal(ToIntFunction<Point> extractor, int region, Map<Integer, List<Map.Entry<Control, BorderData>>> regionMap) {
        List list = regionMap.getOrDefault(region, Collections.emptyList());
        if (list.isEmpty()) {
            return 0;
        }
        return list.stream().mapToInt(entry -> extractor.applyAsInt(((BorderData)entry.getValue()).getSize((Control)entry.getKey()))).sum() + (list.size() - 1) * this.controlSpacing;
    }

    private static int getMax(ToIntFunction<Point> extractor, int region, Map<Integer, List<Map.Entry<Control, BorderData>>> regionMap) {
        List<Map.Entry<Control, BorderData>> list = regionMap.getOrDefault(region, Collections.emptyList());
        return BorderLayout.getMax(extractor, list, -1, -1, false);
    }

    private static int getMax(ToIntFunction<Point> extractor, List<Map.Entry<Control, BorderData>> list, int maxW, int maxH, boolean flushCache) {
        if (list.isEmpty()) {
            return 0;
        }
        if (maxW != -1 || maxH != -1) {
            return list.stream().mapToInt(entry -> extractor.applyAsInt(((BorderData)entry.getValue()).computeSize((Control)entry.getKey(), maxW, maxH, flushCache))).max().orElse(0);
        }
        return list.stream().mapToInt(entry -> extractor.applyAsInt(((BorderData)entry.getValue()).getSize((Control)entry.getKey()))).max().orElse(0);
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        int y;
        int x;
        Rectangle clientArea = composite.getClientArea();
        int clientX = clientArea.x + this.marginWidth;
        int clientY = clientArea.y + this.marginHeight;
        int clientWidth = clientArea.width - 2 * this.marginWidth;
        int clientHeight = clientArea.height - 2 * this.marginHeight;
        Stream<Map.Entry> children = Arrays.stream(composite.getChildren()).map(control -> this.borderDataControl(control, flushCache));
        Map<Integer, List<Map.Entry>> regionMap = children.collect(Collectors.groupingBy(BorderLayout::region));
        regionMap.getOrDefault(0, Collections.emptyList()).forEach(entry -> ((Control)entry.getKey()).setBounds(clientX, clientY, 0, 0));
        List<Map.Entry<Control, BorderData>> northList = regionMap.getOrDefault(128, Collections.emptyList());
        List<Map.Entry<Control, BorderData>> southList = regionMap.getOrDefault(1024, Collections.emptyList());
        List<Map.Entry<Control, BorderData>> westList = regionMap.getOrDefault(16384, Collections.emptyList());
        List<Map.Entry<Control, BorderData>> eastList = regionMap.getOrDefault(131072, Collections.emptyList());
        List centerList = regionMap.getOrDefault(0x1000000, Collections.emptyList());
        int northControlCount = northList.size();
        int northPerControlWidth = northControlCount > 0 ? (clientWidth - (northControlCount - 1) * this.controlSpacing) / northControlCount : 0;
        int northControlHeight = BorderLayout.getMax(HEIGHT, northList, northPerControlWidth, -1, flushCache);
        int southControlCount = southList.size();
        int southPerControlWidth = southControlCount > 0 ? (clientWidth - (southControlCount - 1) * this.controlSpacing) / southControlCount : 0;
        int southControlHeight = BorderLayout.getMax(HEIGHT, southList, southPerControlWidth, -1, flushCache);
        if (northControlHeight + southControlHeight > clientHeight) {
            int distributionSize = (int)((double)clientHeight * this.heightDistributionFactor);
            if (northControlHeight > distributionSize) {
                northControlHeight = distributionSize;
            }
            southControlHeight = clientHeight - northControlHeight;
        }
        int centerControlHeight = clientHeight - northControlHeight - southControlHeight;
        int westControlCount = westList.size();
        int westControlWidth = BorderLayout.getMax(WIDTH, westList, -1, -1, flushCache);
        int eastControlCount = eastList.size();
        int eastControlWidth = BorderLayout.getMax(WIDTH, eastList, -1, -1, flushCache);
        if (westControlWidth + eastControlWidth > clientWidth) {
            int distributionSize = (int)((double)clientWidth * this.widthDistributionFactor);
            if (westControlWidth > distributionSize) {
                westControlWidth = distributionSize;
            }
            eastControlWidth = clientWidth - westControlWidth;
        }
        int centerControlWidth = clientWidth - westControlWidth - eastControlWidth;
        int centerControlCount = centerList.size();
        if (northControlCount > 0) {
            x = clientX;
            y = clientY;
            for (Map.Entry<Control, BorderData> entry2 : northList) {
                entry2.getKey().setBounds(x, y, northPerControlWidth, northControlHeight);
                x += northPerControlWidth + this.controlSpacing;
            }
        }
        if (southControlCount > 0) {
            x = clientX;
            y = clientY + centerControlHeight + northControlHeight;
            for (Map.Entry<Control, BorderData> entry2 : southList) {
                entry2.getKey().setBounds(x, y, southPerControlWidth, southControlHeight);
                x += southPerControlWidth + this.controlSpacing;
            }
        }
        if (westControlCount > 0) {
            x = clientX;
            y = clientY + northControlHeight;
            int h = clientHeight - northControlHeight - southControlHeight;
            if (northControlCount > 0) {
                y += this.spacing;
                h -= this.spacing;
            }
            if (southControlCount > 0) {
                h -= this.spacing;
            }
            int controlHeight = (h - (westControlCount - 1) * this.controlSpacing) / westControlCount;
            for (Map.Entry<Control, BorderData> entry3 : westList) {
                entry3.getKey().setBounds(x, y, westControlWidth, controlHeight);
                y += controlHeight + this.controlSpacing;
            }
        }
        if (eastControlCount > 0) {
            x = clientX + centerControlWidth + westControlWidth;
            y = clientY + northControlHeight;
            int h = clientHeight - northControlHeight - southControlHeight;
            if (northControlCount > 0) {
                y += this.spacing;
                h -= this.spacing;
            }
            if (southControlCount > 0) {
                h -= this.spacing;
            }
            int controlHeight = (h - (eastControlCount - 1) * this.controlSpacing) / eastControlCount;
            for (Map.Entry<Control, BorderData> entry3 : eastList) {
                entry3.getKey().setBounds(x, y, eastControlWidth, controlHeight);
                y += controlHeight + this.controlSpacing;
            }
        }
        if (centerControlCount > 0) {
            int controlWidth;
            int controlHeight;
            x = clientX + westControlWidth;
            y = clientY + northControlHeight;
            int h = centerControlHeight;
            int w = centerControlWidth;
            if (westControlCount > 0) {
                x += this.spacing;
                w -= this.spacing;
            }
            if (eastControlCount > 0) {
                w -= this.spacing;
            }
            if (northControlCount > 0) {
                y += this.spacing;
                h -= this.spacing;
            }
            if (southControlCount > 0) {
                h -= this.spacing;
            }
            if (this.type == 256) {
                controlHeight = h;
                controlWidth = (w - (centerControlCount - 1) * this.controlSpacing) / centerControlCount;
            } else {
                controlWidth = w;
                controlHeight = (h - (centerControlCount - 1) * this.controlSpacing) / centerControlCount;
            }
            for (Map.Entry entry4 : centerList) {
                ((Control)entry4.getKey()).setBounds(x, y, controlWidth, controlHeight);
                if (this.type == 256) {
                    x += controlWidth + this.controlSpacing;
                    continue;
                }
                y += controlHeight + this.controlSpacing;
            }
        }
    }

    private <C extends Control> Map.Entry<C, BorderData> borderDataControl(C control, boolean flushCache) {
        BorderData borderData;
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof BorderData) {
            BorderData borderData2 = (BorderData)layoutData;
            if (flushCache) {
                borderData2.flushCache(control);
            }
            return new AbstractMap.SimpleEntry<C, BorderData>(control, borderData2);
        }
        BorderData borderData3 = borderData = flushCache ? null : (BorderData)control.getData(LAYOUT_KEY);
        if (borderData == null) {
            borderData = new BorderData();
            control.setData(LAYOUT_KEY, borderData);
        }
        return new AbstractMap.SimpleEntry<C, BorderData>(control, borderData);
    }

    private static int region(Map.Entry<Control, BorderData> entry) {
        BorderData borderData = entry.getValue();
        if (borderData == null) {
            return 0x1000000;
        }
        return borderData.getRegion();
    }

    public String toString() {
        return "BorderLayout [type=" + (this.type == 256 ? "SWT.HORIZONTAL" : "SWT.VERTICAL") + ", marginWidth=" + this.marginWidth + ", marginHeight=" + this.marginHeight + ", spacing=" + this.spacing + ", controlSpacing=" + this.controlSpacing + ", widthDistributionFactor=" + this.widthDistributionFactor + ", heightDistributionFactor=" + this.heightDistributionFactor + "]";
    }
}

