﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connectcases/ConnectCases_EXPORTS.h>
#include <aws/connectcases/model/CaseRuleDetails.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ConnectCases {
namespace Model {

/**
 * <p>Detailed case rule information. In the Amazon Connect admin website, case
 * rules are known as <i>case field conditions</i>. For more information about case
 * field conditions, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html">Add
 * case field conditions to a case template</a>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCaseRuleResponse">AWS
 * API Reference</a></p>
 */
class GetCaseRuleResponse {
 public:
  AWS_CONNECTCASES_API GetCaseRuleResponse() = default;
  AWS_CONNECTCASES_API GetCaseRuleResponse(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTCASES_API GetCaseRuleResponse& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECTCASES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Unique identifier of a case rule.</p>
   */
  inline const Aws::String& GetCaseRuleId() const { return m_caseRuleId; }
  inline bool CaseRuleIdHasBeenSet() const { return m_caseRuleIdHasBeenSet; }
  template <typename CaseRuleIdT = Aws::String>
  void SetCaseRuleId(CaseRuleIdT&& value) {
    m_caseRuleIdHasBeenSet = true;
    m_caseRuleId = std::forward<CaseRuleIdT>(value);
  }
  template <typename CaseRuleIdT = Aws::String>
  GetCaseRuleResponse& WithCaseRuleId(CaseRuleIdT&& value) {
    SetCaseRuleId(std::forward<CaseRuleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Name of the case rule.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  GetCaseRuleResponse& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the case rule.</p>
   */
  inline const Aws::String& GetCaseRuleArn() const { return m_caseRuleArn; }
  inline bool CaseRuleArnHasBeenSet() const { return m_caseRuleArnHasBeenSet; }
  template <typename CaseRuleArnT = Aws::String>
  void SetCaseRuleArn(CaseRuleArnT&& value) {
    m_caseRuleArnHasBeenSet = true;
    m_caseRuleArn = std::forward<CaseRuleArnT>(value);
  }
  template <typename CaseRuleArnT = Aws::String>
  GetCaseRuleResponse& WithCaseRuleArn(CaseRuleArnT&& value) {
    SetCaseRuleArn(std::forward<CaseRuleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Represents what rule type should take place, under what conditions.</p>
   */
  inline const CaseRuleDetails& GetRule() const { return m_rule; }
  inline bool RuleHasBeenSet() const { return m_ruleHasBeenSet; }
  template <typename RuleT = CaseRuleDetails>
  void SetRule(RuleT&& value) {
    m_ruleHasBeenSet = true;
    m_rule = std::forward<RuleT>(value);
  }
  template <typename RuleT = CaseRuleDetails>
  GetCaseRuleResponse& WithRule(RuleT&& value) {
    SetRule(std::forward<RuleT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Description of a case rule.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  GetCaseRuleResponse& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether the resource has been deleted.</p>
   */
  inline bool GetDeleted() const { return m_deleted; }
  inline bool DeletedHasBeenSet() const { return m_deletedHasBeenSet; }
  inline void SetDeleted(bool value) {
    m_deletedHasBeenSet = true;
    m_deleted = value;
  }
  inline GetCaseRuleResponse& WithDeleted(bool value) {
    SetDeleted(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Timestamp when the resource was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedTime() const { return m_createdTime; }
  inline bool CreatedTimeHasBeenSet() const { return m_createdTimeHasBeenSet; }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  void SetCreatedTime(CreatedTimeT&& value) {
    m_createdTimeHasBeenSet = true;
    m_createdTime = std::forward<CreatedTimeT>(value);
  }
  template <typename CreatedTimeT = Aws::Utils::DateTime>
  GetCaseRuleResponse& WithCreatedTime(CreatedTimeT&& value) {
    SetCreatedTime(std::forward<CreatedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Timestamp when the resource was created or last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  inline bool LastModifiedTimeHasBeenSet() const { return m_lastModifiedTimeHasBeenSet; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  GetCaseRuleResponse& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A map of of key-value pairs that represent tags on a resource. Tags are used
   * to organize, track, or control access for this resource.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  GetCaseRuleResponse& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  GetCaseRuleResponse& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_caseRuleId;

  Aws::String m_name;

  Aws::String m_caseRuleArn;

  CaseRuleDetails m_rule;

  Aws::String m_description;

  bool m_deleted{false};

  Aws::Utils::DateTime m_createdTime{};

  Aws::Utils::DateTime m_lastModifiedTime{};

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_caseRuleIdHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_caseRuleArnHasBeenSet = false;
  bool m_ruleHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_deletedHasBeenSet = false;
  bool m_createdTimeHasBeenSet = false;
  bool m_lastModifiedTimeHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConnectCases
}  // namespace Aws
