﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>
#include <aws/sagemaker/model/ArtifactSource.h>
#include <aws/sagemaker/model/MetadataProperties.h>
#include <aws/sagemaker/model/UserContext.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {
class DescribeArtifactResult {
 public:
  AWS_SAGEMAKER_API DescribeArtifactResult() = default;
  AWS_SAGEMAKER_API DescribeArtifactResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAGEMAKER_API DescribeArtifactResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the artifact.</p>
   */
  inline const Aws::String& GetArtifactName() const { return m_artifactName; }
  template <typename ArtifactNameT = Aws::String>
  void SetArtifactName(ArtifactNameT&& value) {
    m_artifactNameHasBeenSet = true;
    m_artifactName = std::forward<ArtifactNameT>(value);
  }
  template <typename ArtifactNameT = Aws::String>
  DescribeArtifactResult& WithArtifactName(ArtifactNameT&& value) {
    SetArtifactName(std::forward<ArtifactNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the artifact.</p>
   */
  inline const Aws::String& GetArtifactArn() const { return m_artifactArn; }
  template <typename ArtifactArnT = Aws::String>
  void SetArtifactArn(ArtifactArnT&& value) {
    m_artifactArnHasBeenSet = true;
    m_artifactArn = std::forward<ArtifactArnT>(value);
  }
  template <typename ArtifactArnT = Aws::String>
  DescribeArtifactResult& WithArtifactArn(ArtifactArnT&& value) {
    SetArtifactArn(std::forward<ArtifactArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The source of the artifact.</p>
   */
  inline const ArtifactSource& GetSource() const { return m_source; }
  template <typename SourceT = ArtifactSource>
  void SetSource(SourceT&& value) {
    m_sourceHasBeenSet = true;
    m_source = std::forward<SourceT>(value);
  }
  template <typename SourceT = ArtifactSource>
  DescribeArtifactResult& WithSource(SourceT&& value) {
    SetSource(std::forward<SourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of the artifact.</p>
   */
  inline const Aws::String& GetArtifactType() const { return m_artifactType; }
  template <typename ArtifactTypeT = Aws::String>
  void SetArtifactType(ArtifactTypeT&& value) {
    m_artifactTypeHasBeenSet = true;
    m_artifactType = std::forward<ArtifactTypeT>(value);
  }
  template <typename ArtifactTypeT = Aws::String>
  DescribeArtifactResult& WithArtifactType(ArtifactTypeT&& value) {
    SetArtifactType(std::forward<ArtifactTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of the artifact's properties.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetProperties() const { return m_properties; }
  template <typename PropertiesT = Aws::Map<Aws::String, Aws::String>>
  void SetProperties(PropertiesT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties = std::forward<PropertiesT>(value);
  }
  template <typename PropertiesT = Aws::Map<Aws::String, Aws::String>>
  DescribeArtifactResult& WithProperties(PropertiesT&& value) {
    SetProperties(std::forward<PropertiesT>(value));
    return *this;
  }
  template <typename PropertiesKeyT = Aws::String, typename PropertiesValueT = Aws::String>
  DescribeArtifactResult& AddProperties(PropertiesKeyT&& key, PropertiesValueT&& value) {
    m_propertiesHasBeenSet = true;
    m_properties.emplace(std::forward<PropertiesKeyT>(key), std::forward<PropertiesValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the artifact was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DescribeArtifactResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const UserContext& GetCreatedBy() const { return m_createdBy; }
  template <typename CreatedByT = UserContext>
  void SetCreatedBy(CreatedByT&& value) {
    m_createdByHasBeenSet = true;
    m_createdBy = std::forward<CreatedByT>(value);
  }
  template <typename CreatedByT = UserContext>
  DescribeArtifactResult& WithCreatedBy(CreatedByT&& value) {
    SetCreatedBy(std::forward<CreatedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the artifact was last modified.</p>
   */
  inline const Aws::Utils::DateTime& GetLastModifiedTime() const { return m_lastModifiedTime; }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  void SetLastModifiedTime(LastModifiedTimeT&& value) {
    m_lastModifiedTimeHasBeenSet = true;
    m_lastModifiedTime = std::forward<LastModifiedTimeT>(value);
  }
  template <typename LastModifiedTimeT = Aws::Utils::DateTime>
  DescribeArtifactResult& WithLastModifiedTime(LastModifiedTimeT&& value) {
    SetLastModifiedTime(std::forward<LastModifiedTimeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const UserContext& GetLastModifiedBy() const { return m_lastModifiedBy; }
  template <typename LastModifiedByT = UserContext>
  void SetLastModifiedBy(LastModifiedByT&& value) {
    m_lastModifiedByHasBeenSet = true;
    m_lastModifiedBy = std::forward<LastModifiedByT>(value);
  }
  template <typename LastModifiedByT = UserContext>
  DescribeArtifactResult& WithLastModifiedBy(LastModifiedByT&& value) {
    SetLastModifiedBy(std::forward<LastModifiedByT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const MetadataProperties& GetMetadataProperties() const { return m_metadataProperties; }
  template <typename MetadataPropertiesT = MetadataProperties>
  void SetMetadataProperties(MetadataPropertiesT&& value) {
    m_metadataPropertiesHasBeenSet = true;
    m_metadataProperties = std::forward<MetadataPropertiesT>(value);
  }
  template <typename MetadataPropertiesT = MetadataProperties>
  DescribeArtifactResult& WithMetadataProperties(MetadataPropertiesT&& value) {
    SetMetadataProperties(std::forward<MetadataPropertiesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the lineage group.</p>
   */
  inline const Aws::String& GetLineageGroupArn() const { return m_lineageGroupArn; }
  template <typename LineageGroupArnT = Aws::String>
  void SetLineageGroupArn(LineageGroupArnT&& value) {
    m_lineageGroupArnHasBeenSet = true;
    m_lineageGroupArn = std::forward<LineageGroupArnT>(value);
  }
  template <typename LineageGroupArnT = Aws::String>
  DescribeArtifactResult& WithLineageGroupArn(LineageGroupArnT&& value) {
    SetLineageGroupArn(std::forward<LineageGroupArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeArtifactResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_artifactName;

  Aws::String m_artifactArn;

  ArtifactSource m_source;

  Aws::String m_artifactType;

  Aws::Map<Aws::String, Aws::String> m_properties;

  Aws::Utils::DateTime m_creationTime{};

  UserContext m_createdBy;

  Aws::Utils::DateTime m_lastModifiedTime{};

  UserContext m_lastModifiedBy;

  MetadataProperties m_metadataProperties;

  Aws::String m_lineageGroupArn;

  Aws::String m_requestId;
  bool m_artifactNameHasBeenSet = false;
  bool m_artifactArnHasBeenSet = false;
  bool m_sourceHasBeenSet = false;
  bool m_artifactTypeHasBeenSet = false;
  bool m_propertiesHasBeenSet = false;
  bool m_creationTimeHasBeenSet = false;
  bool m_createdByHasBeenSet = false;
  bool m_lastModifiedTimeHasBeenSet = false;
  bool m_lastModifiedByHasBeenSet = false;
  bool m_metadataPropertiesHasBeenSet = false;
  bool m_lineageGroupArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
