﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanroomsml/CleanRoomsML_EXPORTS.h>
#include <aws/cleanroomsml/model/CollaborationMLInputChannelSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CleanRoomsML {
namespace Model {
class ListCollaborationMLInputChannelsResult {
 public:
  AWS_CLEANROOMSML_API ListCollaborationMLInputChannelsResult() = default;
  AWS_CLEANROOMSML_API ListCollaborationMLInputChannelsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CLEANROOMSML_API ListCollaborationMLInputChannelsResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The token value used to access the next page of results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListCollaborationMLInputChannelsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of ML input channels that you wanted.</p>
   */
  inline const Aws::Vector<CollaborationMLInputChannelSummary>& GetCollaborationMLInputChannelsList() const {
    return m_collaborationMLInputChannelsList;
  }
  template <typename CollaborationMLInputChannelsListT = Aws::Vector<CollaborationMLInputChannelSummary>>
  void SetCollaborationMLInputChannelsList(CollaborationMLInputChannelsListT&& value) {
    m_collaborationMLInputChannelsListHasBeenSet = true;
    m_collaborationMLInputChannelsList = std::forward<CollaborationMLInputChannelsListT>(value);
  }
  template <typename CollaborationMLInputChannelsListT = Aws::Vector<CollaborationMLInputChannelSummary>>
  ListCollaborationMLInputChannelsResult& WithCollaborationMLInputChannelsList(CollaborationMLInputChannelsListT&& value) {
    SetCollaborationMLInputChannelsList(std::forward<CollaborationMLInputChannelsListT>(value));
    return *this;
  }
  template <typename CollaborationMLInputChannelsListT = CollaborationMLInputChannelSummary>
  ListCollaborationMLInputChannelsResult& AddCollaborationMLInputChannelsList(CollaborationMLInputChannelsListT&& value) {
    m_collaborationMLInputChannelsListHasBeenSet = true;
    m_collaborationMLInputChannelsList.emplace_back(std::forward<CollaborationMLInputChannelsListT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListCollaborationMLInputChannelsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<CollaborationMLInputChannelSummary> m_collaborationMLInputChannelsList;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_collaborationMLInputChannelsListHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRoomsML
}  // namespace Aws
