/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.nativeimage;

import com.oracle.svm.core.configure.ResourcesRegistry;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

final class NativeImageFeature
implements Feature {
    private ResourcesRegistry resourcesRegistry;

    NativeImageFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        Class parserFactory;
        Class characterConverterOGS = a.findClassByName("oracle.i18n.text.converter.CharacterConverterOGS");
        if (characterConverterOGS != null) {
            this.initializeAtBuildTime(a, "oracle.i18n.text.converter.CharacterConverterOGS");
            this.initializeAtBuildTime(a, "oracle.i18n.text.converter.CharacterConverterSJIS");
            this.initializeAtBuildTime(a, "oracle.i18n.text.converter.CharacterConverter12Byte");
        }
        if ((parserFactory = a.findClassByName("oracle.xml.jaxp.JXSAXParserFactory")) != null) {
            this.getResourceRegistry().addResourceBundles("oracle.xml.mesg.XMLResourceBundle");
        }
        try {
            for (String className : this.findGeneratedProxies()) {
                this.registerClass(a, className);
                this.registerAllConstructor(a, className);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeAtBuildTime(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{clazz});
        }
    }

    private void registerAll(Feature.BeforeAnalysisAccess a, String className) {
        this.registerClass(a, className);
        this.registerAllConstructor(a, className);
        this.registerAllMethods(a, className);
        this.registerAllFields(a, className);
    }

    private void registerClass(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            RuntimeReflection.register((Class[])new Class[]{clazz});
        }
    }

    private void registerAllConstructor(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            for (Constructor<?> c : clazz.getConstructors()) {
                RuntimeReflection.register((Executable[])new Executable[]{c});
            }
        }
    }

    private void registerAllMethods(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            for (Method m : clazz.getMethods()) {
                RuntimeReflection.register((Executable[])new Executable[]{m});
            }
        }
    }

    private void registerAllFields(Feature.BeforeAnalysisAccess a, String className) {
        Class clazz = a.findClassByName(className);
        if (clazz != null) {
            for (Field f : clazz.getFields()) {
                RuntimeReflection.register((Field[])new Field[]{f});
            }
        }
    }

    private ResourcesRegistry getResourceRegistry() {
        if (this.resourcesRegistry == null) {
            this.resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        }
        return this.resourcesRegistry;
    }

    private List<String> findGeneratedProxies() throws IOException, URISyntaxException {
        Path root;
        String packageName = "oracle.jdbc.proxy";
        String packagePath = packageName.replaceAll("\\.", "/");
        ArrayList<String> proxies = new ArrayList<String>();
        URI packageUri = Objects.requireNonNull(ClassLoader.getSystemClassLoader().getResource(packagePath)).toURI();
        if (packageUri.toString().startsWith("jar:")) {
            try {
                root = FileSystems.getFileSystem(packageUri).getPath(packagePath, new String[0]);
            }
            catch (FileSystemNotFoundException e) {
                root = FileSystems.newFileSystem(packageUri, Collections.emptyMap()).getPath(packagePath, new String[0]);
            }
        } else {
            root = Paths.get(packageUri);
        }
        String extension = ".class";
        try (Stream<Path> allPaths = Files.walk(root, new FileVisitOption[0]);){
            allPaths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String path = file.toString().replace('/', '.');
                String name = path.substring(path.indexOf(packageName), path.length() - ".class".length());
                if (name.endsWith("$$$Proxy")) {
                    proxies.add(name);
                }
            });
        }
        return proxies;
    }
}

