/*
 * Decompiled with CFR 0.152.
 */
package de.danielnaber.jwordsplitter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public final class EmbeddedGermanDictionary {
    private static final String DICT = "/de/danielnaber/jwordsplitter/wordsGerman.txt";
    private static Set<String> words;

    private EmbeddedGermanDictionary() {
    }

    public static synchronized Set<String> getWords() {
        if (words == null) {
            words = new HashSet<String>();
            try (BufferedInputStream is = new BufferedInputStream(EmbeddedGermanDictionary.class.getResourceAsStream(DICT));
                 InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    words.add(line.trim().toLowerCase());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load /de/danielnaber/jwordsplitter/wordsGerman.txt", e);
            }
        }
        return words;
    }
}

